/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.client;

import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.TransactionStatus;
import ru.bitel.common.Utils;

public abstract class TransactionTableModel
extends AbstractTransactionTableModel<Transaction> {
    static final String COLUMN_PAYMENT_ID = "PaymentId";
    static final String COLUMN_EXP_DATE = "ExpDate";
    static final String COLUMN_PAN = "pan";
    static final String COLUMN_ERROR = "error";
    static final String COLUMN_CODE_DESCRIPTION = "Details";
    static final String COLUMN_TITLE_PAYMENT_ID = "Payment ID";
    static final String COLUMN_TITLE_PAN = "\u041a\u0430\u0440\u0442\u0430";
    static final String COLUMN_TITLE_EXP_DATE = "\u041a\u0430\u0440\u0442\u0430 (\u0441\u0440\u043e\u043a)";
    static final String COLUMN_TITLE_ERROR = "\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043f\u0440\u043e\u0441\u0430";
    static final String COLUMN_TITLE_CODE_DESCRIPTION = "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438";

    public TransactionTableModel(String name) {
        super(name, Transaction.class);
    }

    protected Object getStatusValue(Transaction value, int column) throws BGException {
        AbstractTransactionStatus result = TransactionStatus.ALL.getStatusByCode(value.getStatus());
        return result == null ? value.getStatus() : result.getTitle();
    }

    public Object getValue(Transaction value, int column) throws Exception {
        String identifier = this.getIdentifier(column);
        if (COLUMN_PAN.equals(identifier)) {
            String paramValue = this.getParameter(value.getParameters(), "cardAuthInfo.pan");
            if (Utils.isBlankString((String)paramValue)) {
                paramValue = this.getParameter(value.getParameters(), "Pan");
            }
            return paramValue;
        }
        if (COLUMN_ERROR.equals(identifier)) {
            String errorCode = this.getParameter(value.getParameters(), "ErrorCode");
            String errorMessage = this.getParameter(value.getParameters(), "Message");
            return (errorMessage == null ? "" : errorMessage) + (String)(errorCode == null || "0".equals(errorCode) ? "" : " [" + errorCode + "]");
        }
        if (COLUMN_CODE_DESCRIPTION.equals(identifier)) {
            String actionCodeDescription = this.getParameter(value.getParameters(), COLUMN_CODE_DESCRIPTION);
            return actionCodeDescription == null || actionCodeDescription.length() == 0 ? "" : actionCodeDescription;
        }
        if (COLUMN_PAYMENT_ID.equals(identifier)) {
            String paramValue = this.getParameter(value.getParameters(), COLUMN_PAYMENT_ID);
            return paramValue == null || paramValue.length() == 0 ? "" : paramValue;
        }
        if (COLUMN_EXP_DATE.equals(identifier)) {
            String paramValue = this.getParameter(value.getParameters(), COLUMN_EXP_DATE);
            return paramValue == null || paramValue.length() == 0 ? "" : paramValue.substring(0, 2) + "/" + paramValue.substring(2);
        }
        return super.getValue((Object)value, column);
    }
}

