/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.admin;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.license.common.bean.ContractData;
import ru.bitel.bgbilling.modules.license.common.bean.Product;
import ru.bitel.bgbilling.modules.license.common.bean.StatData;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.ListItem;

public class ServiceConfigStat
extends ServiceConfigTabbedPanel {
    private JList<ListItem> productList = new JList();
    private StatTableModel statTableModel = new StatTableModel(StatTableModel.class.getName());
    private ContractTableModel contractTableModel = new ContractTableModel(ContractTableModel.class.getName());

    public ServiceConfigStat() {
        this.productList.setSelectionMode(0);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.getProductPanel(), (Component)this.getRightPanel(), 200L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getProductPanel() {
        this.productList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ((JLabel)component).setText(((ListItem)value).getTitle());
                return component;
            }
        });
        this.productList.addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                this.reloadStat();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.productList);
        scrollPane.setPreferredSize(new Dimension(150, 100));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        BGSplitPaneNoBorder bgSplitPaneNoBorder = new BGSplitPaneNoBorder(1, (Component)this.getStatPanel(), (Component)this.getContractPanel(), -200L);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        panel.add((Component)bgSplitPaneNoBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getStatPanel() {
        BGUTable statTable = new BGUTable((TableModel)((Object)this.statTableModel));
        statTable.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)statTable, e -> this.setContractData());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)statTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getContractPanel() {
        BGUTable contractTable = new BGUTable((TableModel)((Object)this.contractTableModel));
        contractTable.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)contractTable, e -> ClientUtils.openContract((int)((ContractData)this.contractTableModel.getSelectedRow()).getContractId()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)contractTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData() {
        if (this.productList.getModel().getSize() == 0) {
            LicenseService licenseService = (LicenseService)this.getContext().getPort(LicenseService.class);
            DefaultListModel<Product> listModel = new DefaultListModel<Product>();
            try {
                for (Product product : licenseService.productList()) {
                    listModel.addElement(product);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.productList.setModel(listModel);
        } else {
            this.reloadStat();
        }
    }

    private void reloadStat() {
        ListItem listItem = this.productList.getSelectedValue();
        if (listItem != null) {
            try {
                this.statTableModel.setData(((LicenseService)this.getContext().getPort(LicenseService.class)).doStatData(listItem.getId()));
                this.contractTableModel.setData(new ArrayList());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void setContractData() {
        int productId = this.productList.getSelectedValue().getId();
        int componentId = ((StatData)this.statTableModel.getSelectedRow()).getComponent().getId();
        try {
            this.contractTableModel.setData(((LicenseService)this.getContext().getPort(LicenseService.class)).doContractData(productId, componentId));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private class StatTableModel
    extends BGTableModel<StatData> {
        public StatTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442", 100, 200, -1, "component", true, (TableCellRenderer)((Object)new ComponentTableCellRenderer()));
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u043a\u043e\u043f\u0438\u0439", 100, 150, 200, "copyCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0439", 100, 150, 200, "licCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("Unlim", 100, 150, 200, "unlimCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }
    }

    private class ContractTableModel
    extends BGTableModel<ContractData> {
        public ContractTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 120, 150, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "contractComment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    private class ComponentTableCellRenderer
    extends HorizontalAlignmentTableCellRenderer {
        public ComponentTableCellRenderer() {
            super(2);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ru.bitel.bgbilling.modules.license.common.bean.Component component = (ru.bitel.bgbilling.modules.license.common.bean.Component)value;
            return super.getTableCellRendererComponent(table, (Object)(component.getTitle() + " [" + component.getName() + "]"), isSelected, hasFocus, row, column);
        }
    }
}

