/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateAddress;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateAddressManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class GateManager {
    protected int mid = -1;
    protected Connection con;

    public GateManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
    }

    public void deleteGate(int gateID) {
        String query = null;
        try {
            Gate gate = this.getGateById(gateID);
            if (gate != null) {
                PreparedStatement ps = this.con.prepareStatement("UPDATE ipn_gate_" + this.mid + " SET parent_id=? WHERE parent_id=?");
                ps.setInt(1, gate.getParentId() >= 0 ? gate.getParentId() : 0);
                ps.setInt(2, gate.getId());
                ps.executeUpdate();
                ps.close();
            }
            Statement st = this.con.createStatement();
            query = "DELETE FROM ipn_gate_" + this.mid + " WHERE id=" + gateID;
            st.executeUpdate(query);
            st.close();
            query = "DELETE FROM ipn_user_gate_" + this.mid + " WHERE fwid=" + gateID;
            st.executeUpdate(query);
            st.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Gate> getGatesList(GateFilter filter) {
        ArrayList<Gate> result = new ArrayList<Gate>();
        StringBuffer query = new StringBuffer();
        PreparedStatement ps = null;
        try {
            query.append("SELECT * FROM ipn_gate_" + this.mid + " AS gate");
            this.addAddressJoin(query);
            query.append(" WHERE 1=1 ");
            if (filter.getGateId() >= 0) {
                query.append(" AND gate.id = ?");
            }
            if (!Utils.isEmptyString((String)filter.getHost())) {
                query.append(" AND gate.host like ? ");
            }
            if (filter.getType() >= 0) {
                query.append(" AND gate.type = ?");
            }
            if (!Utils.isEmptyString((String)filter.getComment())) {
                query.append(" AND gate.comment like ? ");
            }
            if (filter.getCityId() > 0) {
                query.append(" AND street.cityId = ?");
            }
            if (filter.getStreetId() > 0) {
                query.append(" AND street.id = ?");
            }
            if (filter.getAreaId() > 0) {
                query.append(" AND house.areaId = ?");
            }
            if (filter.getQuarterId() > 0) {
                query.append(" AND house.quarterId = ?");
            }
            if (filter.getHouse() > 0) {
                query.append(" AND house.house = ?");
            }
            if (!Utils.isEmptyString((String)filter.getFrac())) {
                query.append(" AND house.frac like ? ");
            }
            if (filter.getPod() > 0) {
                query.append(" AND address.pod = ?");
            }
            if (filter.getFloor() > 0) {
                query.append(" AND address.floor = ?");
            }
            if (filter.getCid() > 0) {
                query.append(" AND address.floor = ?");
            }
            query.append(" ORDER BY parent_id, host, port");
            ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            if (filter.getGateId() >= 0) {
                ps.setInt(idx++, filter.getGateId());
            }
            if (!Utils.isEmptyString((String)filter.getHost())) {
                ps.setString(idx++, "%" + filter.getHost() + "%");
            }
            if (filter.getType() >= 0) {
                ps.setInt(idx++, filter.getType());
            }
            if (!Utils.isEmptyString((String)filter.getComment())) {
                ps.setString(idx++, "%" + filter.getComment() + "%");
            }
            if (filter.getCityId() > 0) {
                ps.setInt(idx++, filter.getCityId());
            }
            if (filter.getStreetId() > 0) {
                ps.setInt(idx++, filter.getStreetId());
            }
            if (filter.getAreaId() > 0) {
                ps.setInt(idx++, filter.getAreaId());
            }
            if (filter.getQuarterId() > 0) {
                ps.setInt(idx++, filter.getQuarterId());
            }
            if (filter.getHouse() > 0) {
                ps.setInt(idx++, filter.getHouse());
            }
            if (!Utils.isEmptyString((String)filter.getFrac())) {
                ps.setString(idx++, "%" + filter.getFrac() + "%");
            }
            if (filter.getPod() > 0) {
                ps.setInt(idx++, filter.getPod());
            }
            if (filter.getFloor() > 0) {
                ps.setInt(idx++, filter.getFloor());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Gate gate = new Gate();
                GateManager.loadFromResultSet(rs, gate);
                result.add(gate);
            }
            if (filter.isLoadParents()) {
                this.addParents(result, result);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Gate> getGatesList() {
        return this.getGatesList(new GateFilter());
    }

    private void addParents(List<Gate> result, List<Gate> level) {
        Gate gate;
        StringBuffer query = new StringBuffer();
        PreparedStatement ps = null;
        if (level.size() == 0) {
            return;
        }
        StringBuffer parentList = new StringBuffer();
        for (int i = 0; i < level.size(); ++i) {
            Gate gate2 = level.get(i);
            if (gate2.getParentId() <= 0) continue;
            parentList.append(gate2.getParentId());
            parentList.append(",");
        }
        parentList.append("-10");
        StringBuffer childList = new StringBuffer();
        for (int i = 0; i < result.size(); ++i) {
            gate = result.get(i);
            childList.append(gate.getId());
            childList.append(",");
        }
        childList.append("-10");
        try {
            query.append("SELECT * FROM ipn_gate_" + this.mid + " AS gate");
            this.addAddressJoin(query);
            query.append(" WHERE 1=1 ");
            query.append(" AND  gate.id IN (" + parentList + ")");
            query.append(" AND  gate.id not IN (" + childList + ")");
            ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            level = new ArrayList<Gate>();
            while (rs.next()) {
                gate = new Gate();
                GateManager.loadFromResultSet(rs, gate);
                result.add(gate);
                level.add(gate);
            }
            this.addParents(result, level);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addAddressJoin(StringBuffer query) {
        query.append(" LEFT JOIN ipn_gate_address_" + this.mid + " AS address ON gate.id=address.gid  LEFT JOIN address_house as house ON house.id=address.hid  LEFT JOIN address_street as street ON street.id=house.streetId ");
    }

    public Gate getGateTree(GateFilter filter) {
        List<Gate> gateList = this.getGatesList(filter);
        Gate root = new Gate();
        root.setId(0);
        HashMap<Integer, Gate> gateMap = new HashMap<Integer, Gate>();
        gateMap.put(root.getId(), root);
        root.setChildren(new ArrayList<Gate>());
        for (Gate g : gateList) {
            gateMap.put(g.getId(), g);
            g.setChildren(new ArrayList<Gate>());
        }
        for (Gate g : gateList) {
            Gate parent = (Gate)gateMap.get(g.getParentId());
            if (parent != null) {
                parent.getChildren().add(g);
                continue;
            }
            root.getChildren().add(g);
        }
        return root;
    }

    public static void loadFromResultSet(ResultSet rs, Gate gate) throws SQLException {
        GateManager.loadFromResultSet(rs, gate, true);
    }

    public static void loadFromResultSet(ResultSet rs, Gate gate, boolean loadAddress) throws SQLException {
        gate.setId(rs.getInt("gate.id"));
        gate.setTypeId(rs.getInt("gate.type"));
        gate.setHost(rs.getString("gate.host"));
        gate.setPort(rs.getInt("gate.port"));
        gate.setComment(rs.getString("gate.comment"));
        gate.setConfig(rs.getString("gate.config"));
        gate.setKeyword(rs.getString("gate.keyword"));
        gate.setParentId(rs.getInt("gate.parent_id"));
        if (loadAddress) {
            GateAddress address = new GateAddress();
            GateAddressManager.loadFromResultSet(rs, address);
            gate.setAddress(address);
        }
    }

    public Gate getGateById(int gateId) {
        Gate result = null;
        GateFilter filter = new GateFilter();
        filter.setGateId(gateId);
        List<Gate> gates = this.getGatesList(filter);
        if (gates.size() > 0) {
            result = gates.get(0);
        }
        return result;
    }

    @Deprecated
    public Gate getGateByID(int gateId) {
        return this.getGateById(gateId);
    }

    public void moveGates(String ids, int id) {
        List idList = Utils.toIntegerList((String)ids);
        try {
            HashSet<Integer> parentIds = new HashSet<Integer>();
            Gate gate = this.getGateById(id);
            if (gate != null) {
                while (gate != null) {
                    parentIds.add(gate.getId());
                    gate = this.getGateById(gate.getParentId());
                }
            } else {
                id = 0;
            }
            PreparedStatement ps = this.con.prepareStatement("UPDATE ipn_gate_" + this.mid + " SET parent_id=? WHERE id!=? AND id=?");
            ps.setInt(1, id);
            ps.setInt(2, id);
            for (Integer i : idList) {
                if (parentIds.contains(i)) continue;
                ps.setInt(3, i);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateGate(String gateID, Gate gate) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if ("new".equals(gateID)) {
                query = "INSERT INTO ipn_gate_" + this.mid + " ( host, port, keyword, comment, type, config, parent_id ) VALUES ( ?, ?, ?, ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query, 1);
                ps.setString(1, gate.getHost());
                ps.setInt(2, gate.getPort());
                ps.setString(3, gate.getKeyword() == null ? "" : gate.getKeyword());
                ps.setString(4, gate.getComment() == null ? "" : gate.getComment());
                ps.setInt(5, gate.getTypeId());
                ps.setString(6, gate.getConfig());
                ps.setInt(7, gate.getParentId());
                ps.executeUpdate();
                gate.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            } else {
                query = "UPDATE ipn_gate_" + this.mid + " SET host=?, port=?, keyword=?, comment=?, type=?, config=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setString(1, gate.getHost());
                ps.setInt(2, gate.getPort());
                ps.setString(3, gate.getKeyword() == null ? "" : gate.getKeyword());
                ps.setString(4, gate.getComment() == null ? "" : gate.getComment());
                ps.setInt(5, gate.getTypeId());
                ps.setString(6, gate.getConfig());
                ps.setString(7, gateID);
                ps.executeUpdate();
                gate.setId(Integer.valueOf(gateID));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Gate> getContractGates(int cid) {
        ArrayList<Gate> result = new ArrayList<Gate>();
        PreparedStatement ps = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT fwid FROM ipn_user_gate_" + this.mid + " WHERE cid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            StringBuffer fwids = new StringBuffer("-1");
            while (rs.next()) {
                fwids.append(",");
                fwids.append(rs.getInt(1));
            }
            ps.close();
            query = new StringBuffer();
            query.append("SELECT * FROM ipn_gate_" + this.mid + " as gate ");
            this.addAddressJoin(query);
            query.append(" WHERE gate.id IN ( " + fwids.toString() + " ) ORDER BY host, port ");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                Gate gate = new Gate();
                result.add(gate);
                GateManager.loadFromResultSet(rs, gate);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Gate> getGateByTypeId(int typeId) {
        GateFilter filter = new GateFilter();
        filter.setType(typeId);
        return this.getGatesList(filter);
    }

    @Deprecated
    public List<Gate> getGateByTypeID(int typeId) {
        return this.getGateByTypeId(typeId);
    }
}

