/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.level;

import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public class DeviceLevelTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    private int fromLevel;
    private int toLevel;

    public DeviceLevelTariffTreeNode(int id, ParameterMap params) {
        super(id, params);
        this.fromLevel = params.getInt("levelFrom", 0);
        this.toLevel = params.getInt("levelTo", 0);
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, InetTariffContext context, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        if (context.realtime) {
            int level;
            int deviceId;
            int n = deviceId = req.connectionRuntime != null ? req.connectionRuntime.connection.getDeviceId() : req.deviceId;
            if (deviceId == 0) {
                deviceId = req.inetServRuntime.getInetServ().getDeviceId();
            }
            if ((level = context.getLevelManager().getLevel(deviceId)) >= this.fromLevel && (this.toLevel >= level || this.toLevel <= 0)) {
                return 1;
            }
        }
        return 0;
    }
}

