/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopDirectoryItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopItemType;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopProductTreeItem;
import ru.bitel.bgbilling.plugins.shop.common.service.ShopService;
import ru.bitel.bgbilling.plugins.shop.server.dao.ShopDirectoryItemDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.ShopItemDao;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.shop.common.service.ShopService")
public class ShopServiceImpl
extends AbstractService
implements ShopService {
    private ShopItemDao shopItemDao;
    private ShopDirectoryItemDao shopDirectoryItemDao;

    @PostConstruct
    private void init() {
        this.shopItemDao = new ShopItemDao(this.getConnection());
        this.shopDirectoryItemDao = new ShopDirectoryItemDao(this.getConnection());
    }

    public List<ShopItemType> shopItemTypeList() throws Exception {
        return this.shopItemDao.list();
    }

    public List<ShopItemType> shopItemTypeListByIds(List<Integer> itemTypeIds) throws Exception {
        return this.shopItemDao.list(itemTypeIds);
    }

    public int shopItemTypeUpdate(ShopItemType shopItemType) throws Exception {
        this.shopItemDao.update(shopItemType);
        return shopItemType.getId();
    }

    public List<ShopDirectoryItem> shopDirectoryItemList() throws Exception {
        return this.shopDirectoryItemDao.list();
    }

    public int shopDirectoryItemUpdate(ShopDirectoryItem shopDirectoryItem) throws Exception {
        this.shopDirectoryItemDao.update(shopDirectoryItem);
        return shopDirectoryItem.getId();
    }

    public List<ShopProductTreeItem> shopProductTreeItemList() throws Exception {
        ArrayList<ShopProductTreeItem> items = new ArrayList<ShopProductTreeItem>();
        items.addAll(this.shopDirectoryItemDao.list().stream().map(ShopDirectoryItem::toShopProductTreeItem).toList());
        return items;
    }
}

