/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.snmp;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.snmp.SnmpFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SnmpFlowRecord;

public class SnmpDataLogReader
extends BGDataLogReader<IPDataLog>
implements FlowReader {
    public static final String PARAM_LAST_SNMP = " ru.bitel.bgbilling.server.util.ip.datalog.snmp.SnmpDataLogReader.LAST_SNMP";
    protected final SnmpFlowArray recordList;

    public SnmpDataLogReader(IPDataLog dataLog, Map<String, Object> params) {
        super(dataLog);
        HashMap<Integer, SnmpFlowRecord> lastSNMP;
        this.readBuffer.position(this.readBuffer.capacity());
        if (params == null) {
            params = Collections.emptyMap();
        }
        if ((lastSNMP = (HashMap<Integer, SnmpFlowRecord>)params.get(PARAM_LAST_SNMP)) == null) {
            lastSNMP = new HashMap<Integer, SnmpFlowRecord>();
            params.put(PARAM_LAST_SNMP, lastSNMP);
        }
        this.recordList = new SnmpFlowArray(this.readBuffer, lastSNMP);
        this.recordList.size = 2;
    }

    @Override
    protected ByteBuffer createBuffer(IPDataLog dataLog, ByteBuffer readBuffer) {
        int size = 0x300000;
        int recordSize = 76;
        size = size % recordSize * recordSize;
        return ByteBuffer.allocate(size);
    }

    public FlowArray<SnmpFlowRecord> readChunk() {
        while (this.readNext()) {
            try {
                int offset = this.recordList.next(this.readBuffer.position());
                this.readBuffer.position(offset);
                return this.recordList;
            }
            catch (Exception e) {
                System.err.println(((IPDataLog)this.dataLog).getFile());
                e.printStackTrace();
                this.readBuffer.limit(this.readBuffer.capacity());
                this.readBuffer.position(this.readBuffer.capacity());
            }
        }
        return null;
    }
}

