/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.City;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.House;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.Street;
import ru.bitel.bgbilling.plugins.fias.server.bean.AddressLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.bean.BaseLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.util.FiasUtil;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class HouseLoadManager
extends BaseLoadManager {
    private PreparedStatement addHousePs;
    private PreparedStatement updateHousePS;

    public HouseLoadManager(Connection con) {
        super(con);
    }

    public int getStreetCountWithoutSync() throws Exception {
        int result = -1;
        String query = "SELECT count(*) FROM " + FIAS_STREET_MAP + " AS t_fias  LEFT JOIN " + ADDRESS_STREET + " AS t_street ON t_street.id=t_fias.id WHERE status<=0 AND region <>'' ORDER BY  status DESC,offname desc";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        return result;
    }

    public Street getNonSyncStreet() throws Exception {
        Street street = new Street();
        String query = "SELECT t_fias.id, t_fias.aoguid,t_fias.region,t_street.title FROM " + FIAS_STREET_MAP + " AS t_fias  LEFT JOIN " + ADDRESS_STREET + " AS t_street ON t_street.id=t_fias.id WHERE status<=0 AND region <>'' ORDER BY  status DESC,offname desc";
        try (Statement st = this.con.createStatement();
             ResultSet rs = this.executeQuery(st, query);){
            if (rs.next()) {
                street.setId(rs.getInt(1));
                street.setAoguid(rs.getString(2));
                street.setRegion(rs.getString(3));
                street.setBgTitle(rs.getString(4));
            }
        }
        return street;
    }

    public void createNewTempTable(Street street) throws BGException {
        Connection fiasCon = null;
        try {
            long start = System.currentTimeMillis();
            this.getLogger().info("createNewTempTable..." + street.getBgTitle());
            Statement st = this.con.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS  " + FIAS_HOUSE_TEMP);
            st.executeUpdate("CREATE TABLE " + FIAS_HOUSE_TEMP + " ( `street_id` INT(11) NOT NULL, `street_title` VARCHAR(100) NOT NULL, `aoguid` VARCHAR(100) NOT NULL, `houseguid` VARCHAR(100) NOT NULL, `housenum` VARCHAR(20) NOT NULL, `buildnum` VARCHAR(20) NOT NULL, `strucnum` VARCHAR(100) NOT NULL,  `eststatus` VARCHAR(100) NOT NULL, `strstatus` VARCHAR(100) NOT NULL, `postalcode` VARCHAR(10) NOT NULL,  INDEX `houseguid` (`houseguid`), INDEX `aoguid` (`aoguid`)   )");
            st.close();
            String query = "INSERT INTO " + FIAS_HOUSE_TEMP + " SET street_id=?,street_title=?,aoguid=?,houseguid=?,housenum=?,buildnum=?,strucnum=?,eststatus=?,strstatus=?,postalcode=?";
            PreparedStatement bgPs = this.con.prepareStatement(query);
            fiasCon = FiasUtil.getFiasConnection();
            PreparedStatement fiasPs = fiasCon.prepareStatement("SELECT  * FROM house" + street.getRegion() + " WHERE  aoguid = ? AND STR_TO_DATE(STARTDATE,'%d.%m.%Y')<= ? AND STR_TO_DATE(ENDDATE,'%d.%m.%Y')>?");
            int index = 1;
            fiasPs.setString(index++, street.getAoguid());
            GregorianCalendar now = new GregorianCalendar();
            fiasPs.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            fiasPs.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ResultSet fiasRs = this.executeQuery(fiasPs);
            int count = 0;
            while (fiasRs.next()) {
                index = 1;
                bgPs.setInt(index++, street.getId());
                bgPs.setString(index++, street.getBgTitle());
                bgPs.setString(index++, fiasRs.getString("aoguid"));
                bgPs.setString(index++, fiasRs.getString("houseguid"));
                bgPs.setString(index++, fiasRs.getString("housenum"));
                bgPs.setString(index++, fiasRs.getString("buildnum"));
                bgPs.setString(index++, fiasRs.getString("strucnum"));
                bgPs.setString(index++, fiasRs.getString("eststatus"));
                bgPs.setString(index++, fiasRs.getString("strstatus"));
                bgPs.setString(index++, fiasRs.getString("postalcode"));
                bgPs.executeUpdate();
                ++count;
            }
            fiasRs.close();
            fiasPs.close();
            bgPs.close();
            ServerUtils.closeConnection((Connection)fiasCon);
            long delta = System.currentTimeMillis() - start;
            this.getLogger().info("createNewTempTable ..." + count + "=>" + delta + " ms");
        }
        catch (SQLException ex) {
            try {
                this.logError(ex);
                throw new BGException((Throwable)ex);
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(fiasCon);
                throw throwable;
            }
        }
        ServerUtils.closeConnection((Connection)fiasCon);
    }

    private PreparedStatement getUpdateHousePS() throws SQLException {
        if (this.updateHousePS == null) {
            String query = "INSERT INTO " + FIAS_HOUSE_MAP + " SET id=?, aoguid=?,houseguid=?,housenum=?,buildnum=?,strucnum=?,eststatus=?,strstatus=?,postalcode=?";
            this.updateHousePS = this.con.prepareStatement(query);
        }
        return this.updateHousePS;
    }

    public void updateHouse(House house) throws Exception {
        try {
            PreparedStatement ps = this.getUpdateHousePS();
            int index = 1;
            ps.setInt(index++, house.getId());
            ps.setString(index++, house.getAoguid());
            ps.setString(index++, house.getHouseguid());
            ps.setString(index++, house.getHousenum());
            ps.setString(index++, house.getBuildnum());
            ps.setString(index++, house.getStrucnum());
            ps.setString(index++, house.getEststatus());
            ps.setString(index++, house.getStrstatus());
            ps.setString(index++, house.getPostalcode());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
        this.delHouseFromFiasTemp(house.getHouseguid());
    }

    private void delHouseFromFiasTemp(String houseguid) {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM " + FIAS_HOUSE_TEMP + " WHERE houseguid='" + houseguid + "'");
            st.close();
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
    }

    public void addAllHouse() throws Exception {
        long start = System.currentTimeMillis();
        this.getLogger().info("Start add new house from fias..");
        try {
            String query = "SELECT t_house.aoguid,t_house.houseguid,t_house.housenum,t_house.buildnum,t_house.strucnum,t_house.eststatus,t_house.strstatus,t_house.street_title,t_house.street_id, t_house.postalcode  FROM " + FIAS_HOUSE_TEMP + " AS t_house LEFT JOIN " + FIAS_HOUSE_MAP + " AS t_fias ON t_fias.houseguid= t_house.houseguid WHERE t_fias.aoguid IS NULL ";
            Statement st = this.con.createStatement();
            ResultSet rs = this.executeQuery(st, query);
            int all = 0;
            int count = 0;
            int error = 0;
            while (rs.next()) {
                ++all;
                House house = this.loadHouseFromRs(rs);
                house.setStreetId(rs.getInt("street_id"));
                try {
                    this.setHouseAndFrac(house);
                    this.addHouseToBilling(house);
                    this.updateHouse(house);
                    ++count;
                }
                catch (BGException e) {
                    ++error;
                }
                if (count % 1000 != 0) continue;
                this.getLogger().info("Process " + count + "house..");
            }
            rs.close();
            st.close();
            long delta = System.currentTimeMillis() - start;
            this.getLogger().info("Add " + count + " house from " + all + " error " + error + "=>" + delta + " ms");
        }
        catch (SQLException ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    private PreparedStatement getAddHousePs() throws SQLException {
        if (this.addHousePs == null) {
            this.addHousePs = this.con.prepareStatement("INSERT INTO " + ADDRESS_HOUSE + " SET streetid=?, house=?,frac=?", 1);
        }
        return this.addHousePs;
    }

    private void addHouseToBilling(House house) throws BGException {
        try {
            PreparedStatement ps = this.getAddHousePs();
            int index = 1;
            ps.setInt(index++, house.getStreetId());
            ps.setString(index++, house.getHousenum());
            ps.setString(index++, house.getBuildnum() + house.getStrucnum());
            ps.executeUpdate();
            if (house.getId() <= 0) {
                house.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public House getNextHouse(int streetId) throws BGException {
        try {
            String query = "select t_house.id,t_house.house, t_house.frac,t_street.title FROM  " + ADDRESS_HOUSE + " AS t_house LEFT JOIN " + FIAS_HOUSE_MAP + " AS t_fias ON t_fias.id= t_house.id LEFT JOIN " + ADDRESS_STREET + " AS t_street ON t_street.id=t_house.streetid WHERE t_fias.aoguid IS NULL AND t_house.streetid =" + streetId + " LIMIT 1";
            Statement st = this.con.createStatement();
            ResultSet rs = this.executeQuery(st, query);
            House result = null;
            if (rs.next()) {
                result = new House();
                int index = 1;
                result.setId(rs.getInt(index++));
                result.setBgHousenum(rs.getString(index++));
                result.setBgFrac(rs.getString(index++));
                result.setStreetTitle(rs.getString(index++));
                result.setStreetId(streetId);
            }
            rs.close();
            st.close();
            return result;
        }
        catch (SQLException ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public List<House> findHouseInFias(House house) throws BGException {
        try {
            ResultSet rs;
            ArrayList<House> result = new ArrayList<House>();
            String frac = house.getBgFrac();
            if (Utils.isEmptyString((String)frac)) {
                st = this.con.prepareStatement("SELECT aoguid,houseguid,housenum,buildnum,strucnum,eststatus,strstatus,street_title,postalcode FROM " + FIAS_HOUSE_TEMP + " WHERE housenum = ? AND buildnum='' AND strucnum='' ORDER BY housenum,buildnum, strucnum");
                st.setString(1, house.getBgHousenum());
                rs = this.executeQuery(st);
                while (rs.next()) {
                    result.add(this.loadHouseFromRs(rs));
                }
                rs.close();
                st.close();
                if (result.size() > 0) {
                    return result;
                }
            } else {
                st = this.con.prepareStatement("SELECT aoguid,houseguid,housenum,buildnum,strucnum,eststatus,strstatus,street_title,postalcode FROM " + FIAS_HOUSE_TEMP + " WHERE housenum = ? AND buildnum='' AND strucnum='' ORDER BY housenum,buildnum, strucnum");
                st.setString(1, house.getBgHousenum() + house.getBgFrac());
                rs = this.executeQuery(st);
                while (rs.next()) {
                    result.add(this.loadHouseFromRs(rs));
                }
                rs.close();
                st.close();
                if (result.size() > 0) {
                    return result;
                }
                if (frac.length() > 0 && (frac.charAt(0) == '/' || frac.charAt(0) == '\\')) {
                    frac = frac.substring(1, frac.length());
                }
                PreparedStatement st2 = this.con.prepareStatement("SELECT aoguid,houseguid,housenum,buildnum,strucnum,eststatus,strstatus,street_title,postalcode FROM " + FIAS_HOUSE_TEMP + " WHERE housenum = ? AND  ( buildnum = ? OR strucnum = ? ) ORDER BY housenum,buildnum, strucnum");
                st2.setString(1, house.getBgHousenum());
                st2.setString(2, frac);
                st2.setString(3, frac);
                ResultSet rs2 = this.executeQuery(st2);
                while (rs2.next()) {
                    result.add(this.loadHouseFromRs(rs2));
                }
                rs2.close();
                st2.close();
                if (result.size() > 0) {
                    return result;
                }
            }
            PreparedStatement st2 = this.con.prepareStatement("SELECT aoguid,houseguid,housenum,buildnum,strucnum,eststatus,strstatus,street_title,postalcode FROM " + FIAS_HOUSE_TEMP + " WHERE housenum LIKE ?  ORDER BY housenum,buildnum, strucnum");
            st2.setString(1, "%" + house.getBgHousenum() + "%");
            rs = this.executeQuery(st2);
            while (rs.next()) {
                result.add(this.loadHouseFromRs(rs));
            }
            if (result.size() == 1) {
                result.add(new House());
            }
            rs.close();
            st2.close();
            return result;
        }
        catch (SQLException ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
    }

    public void updateStreetStatus(int streetId, int status) {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("UPDATE " + FIAS_STREET_MAP + " SET status=" + status + " WHERE id=" + streetId);
            st.close();
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
    }

    private House loadHouseFromRs(ResultSet rs) throws SQLException {
        House house = new House();
        house.setAoguid(rs.getString("aoguid"));
        house.setHouseguid(rs.getString("houseguid"));
        house.setHousenum(rs.getString("housenum"));
        String buildNum = rs.getString("buildnum");
        buildNum = buildNum.equals("0") ? "" : buildNum;
        house.setBuildnum(buildNum);
        String structNum = rs.getString("strucnum");
        structNum = structNum.equals("0") ? "" : structNum;
        house.setStrucnum(structNum);
        house.setStreetTitle(rs.getString("street_title"));
        house.setEststatus(rs.getString("eststatus"));
        house.setStrstatus(rs.getString("strstatus"));
        house.setPostalcode(rs.getString("postalcode"));
        return house;
    }

    public void setHouseAndFrac(House house) {
        String frac = "";
        String houseAndFrac = house.getHousenum();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < houseAndFrac.length(); ++i) {
            char ch = houseAndFrac.charAt(i);
            if (!Character.isDigit(ch)) {
                frac = houseAndFrac.substring(i);
                break;
            }
            str.append(ch);
        }
        if (Utils.isEmptyString((String)frac)) {
            return;
        }
        house.setHousenum(str.toString());
        house.setBuildnum(frac + house.getBuildnum());
    }

    public void syncHouse(List<City> citys, boolean loadNew) throws Exception {
        this.getLogger().info("Start sync house.. ");
        AddressLoadManager lm = new AddressLoadManager(this.con);
        lm.clearFiasTable();
        if (citys == null || citys.isEmpty()) {
            citys = lm.getCityList();
        }
        for (City city : citys) {
            this.getLogger().info("Sync city:" + city.getBgTitle() + "[" + city.getId() + "]");
            if (Utils.isEmptyString((String)city.getAoguid())) {
                this.getLogger().info("City not from fias..");
                continue;
            }
            this.createNewTempTableForCity(city);
            this.syncHouseFromMapTable();
            if (!loadNew) continue;
            this.addAllHouse();
        }
    }

    public void createNewTempTableForCity(City city) throws BGException {
        long start = System.currentTimeMillis();
        this.getLogger().info("Load new temp table for house.. ");
        Connection fiasCon = null;
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS  " + FIAS_HOUSE_TEMP);
            st.executeUpdate("CREATE TABLE " + FIAS_HOUSE_TEMP + " ( `street_id` INT(11) NOT NULL, `street_title` VARCHAR(100) NOT NULL, `aoguid` VARCHAR(100) NOT NULL, `houseguid` VARCHAR(100) NOT NULL, `housenum` VARCHAR(20) NOT NULL, `buildnum` VARCHAR(20) NOT NULL, `strucnum` VARCHAR(100) NOT NULL,  `eststatus` VARCHAR(100) NOT NULL, `strstatus` VARCHAR(100) NOT NULL, `postalcode` VARCHAR(10) NOT NULL, INDEX `houseguid` (`houseguid`),INDEX `aoguid` (`aoguid`)   )");
            String query = "INSERT INTO " + FIAS_HOUSE_TEMP + " SET street_id=?,street_title=?,aoguid=?,houseguid=?,housenum=?,buildnum=?,strucnum=?,eststatus=?,strstatus=?,postalcode=?";
            PreparedStatement bgPs = this.con.prepareStatement(query);
            fiasCon = FiasUtil.getFiasConnection();
            PreparedStatement fiasPs = fiasCon.prepareStatement("SELECT a.shortname,a.offname,a.aoguid,h.houseguid,h.housenum,h.buildnum,h.strucnum,h.eststatus,h.strstatus,h.postalcode FROM addrobj" + city.getRegion() + " as a JOIN house" + city.getRegion() + " as h ON h.AOGUID = a.AOGUID WHERE a.actstatus =1 AND STR_TO_DATE(h.STARTDATE,'%d.%m.%Y')<=? AND STR_TO_DATE(h.ENDDATE,'%d.%m.%Y')>? AND a.parentguid=?");
            int index = 1;
            GregorianCalendar now = new GregorianCalendar();
            fiasPs.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            fiasPs.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            fiasPs.setString(index++, city.getAoguid());
            ResultSet fiasRs = this.executeQuery(fiasPs);
            int count = 0;
            while (fiasRs.next()) {
                index = 1;
                bgPs.setInt(index++, -1);
                bgPs.setString(index++, fiasRs.getString("a.shortname") + fiasRs.getString("a.offname"));
                bgPs.setString(index++, fiasRs.getString("aoguid"));
                bgPs.setString(index++, fiasRs.getString("houseguid"));
                bgPs.setString(index++, fiasRs.getString("housenum"));
                bgPs.setString(index++, fiasRs.getString("buildnum"));
                bgPs.setString(index++, fiasRs.getString("strucnum"));
                bgPs.setString(index++, fiasRs.getString("eststatus"));
                bgPs.setString(index++, fiasRs.getString("strstatus"));
                bgPs.setString(index++, fiasRs.getString("postalcode"));
                bgPs.executeUpdate();
                if (++count % 10000 != 0) continue;
                this.getLogger().info("Load " + count + "house..");
            }
            fiasRs.close();
            fiasPs.close();
            bgPs.close();
            ServerUtils.closeConnection((Connection)fiasCon);
            long delta = System.currentTimeMillis() - start;
            this.getLogger().info("Load all " + count + "house..." + delta + " ms");
            st.executeUpdate("UPDATE fias_house_temp AS t  SET t.street_id = (SELECT id FROM fias_street_map WHERE aoguid=t.aoguid) ");
            int i = st.executeUpdate("DELETE FROM fias_house_temp WHERE street_id = -1");
            this.getLogger().info("Delete " + i + " house, not have street");
            st.close();
        }
        catch (SQLException ex) {
            try {
                this.logError(ex);
                throw new BGException((Throwable)ex);
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(fiasCon);
                throw throwable;
            }
        }
        ServerUtils.closeConnection((Connection)fiasCon);
    }

    public void syncHouseFromMapTable() {
        long start = System.currentTimeMillis();
        this.getLogger().info("syncHouseFromMapTable...");
        try {
            Statement st = this.con.createStatement();
            int i = st.executeUpdate("UPDATE fias_house_map AS t1 JOIN fias_house_temp AS t2  ON t2.houseguid=t1.houseguid SET  t1.housenum =t2.housenum, t1.buildnum = t2.buildnum,t1.strucnum =t2.strucnum,t1.strstatus = t2.strstatus, t1.eststatus = t2.eststatus,t1.postalcode = t2.postalcode");
            st.close();
            this.getLogger().info("Sync " + i + " house");
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        long delta = System.currentTimeMillis() - start;
        this.getLogger().info("syncHouseFromMapTable..." + delta + " ms");
    }
}

