/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.action;

import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrAddress;
import ru.bitel.bgbilling.plugins.cladr.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.cladr.server.dao.AddressDBFDAO;

public class ActionSearchObject
extends ActionBase {
    public void doAction() throws Exception {
        try {
            if (!this.checkParam()) {
                throw new BGIllegalArgumentException();
            }
            AddressDBFDAO addrDAO = new AddressDBFDAO(this.con);
            String searchString = this.getParameter("searchString");
            String[] words = searchString.split(" ");
            List<String> codes = addrDAO.getCodesBySearchString(words);
            Element items = this.createElement(this.rootNode, "address");
            for (String code : codes) {
                CladrAddress address = addrDAO.getAddressByCode(code);
                Element item = this.createElement(items, "item");
                item.setAttribute("code", address.getCode());
                item.setAttribute("socr", address.getSocr());
                item.setAttribute("name", address.getName());
                StringBuilder path = new StringBuilder();
                for (Integer i : this.getAddressLevel(code, item)) {
                    CladrAddress addrPath = addrDAO.getAddressLevelByCode(code, i);
                    if (addrPath == null) continue;
                    path.append(addrPath.getSocr() + " " + addrPath.getName() + "->");
                }
                path.delete(path.length() - 2, path.length());
                item.setAttribute("path", path.toString());
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private boolean checkParam() {
        return this.getParameter("searchString") != null;
    }

    private Vector<Integer> getAddressLevel(String code, Element item) {
        String ppp;
        String ggg;
        String rrr;
        Vector<Integer> res = new Vector<Integer>();
        String ss = code.substring(0, 2);
        if (!ss.equals("00")) {
            res.add(1);
            item.setAttribute("region", "1");
        }
        if (!(rrr = code.substring(2, 5)).equals("000")) {
            res.add(2);
            item.setAttribute("area", "1");
        }
        if (!(ggg = code.substring(5, 8)).equals("000")) {
            res.add(3);
        }
        if (!(ppp = code.substring(8, 11)).equals("000")) {
            res.add(4);
        }
        return res;
    }
}

