<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:bg="ru.bitel.bgbilling.server.util.exslt.BGXsltFunctions">
	
	<xalan:component prefix="bg" functions="counterAdd counterSet counterGet summaToString">
		<xalan:script lang="javaclass" src="xalan://ru.bitel.bgbilling.server.util.exslt.BGXsltFunctions"/>
  	</xalan:component>

	<xsl:output encoding="UTF-8" method='xml' indent='yes' />
	
	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->	
	<xsl:variable name="postal_address" select="'450001, Российская Федерация, Республика Башкортостан, г.Уфа, проспект Октября, д.4, адм. здание'" />
	<xsl:variable name="INN" select="'ИНН 0278109628'" />
	<xsl:variable name="KPP" select="'КПП 027801001'" />
	<xsl:variable name="title" select="'ОАО &quot;Уфанет&quot;'" />

	<xsl:variable name="OKVED" select="'ОКВЭД 82000'" />
	<xsl:variable name="OKPO" select="'ОКПО 45219144'" />
	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->


	<xsl:variable name="currency" select="'рубль'" />

	<xsl:attribute-set name="text">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.0cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.0cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_ban">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_bold">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_title">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.3cm</xsl:attribute>
		<xsl:attribute name="space-after">0.2cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table_text_left">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>

		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell_border">
		<xsl:attribute name="border-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table_text_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	
	<xsl:template match="data">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:call-template name="act"/>
		</fo:root>
	</xsl:template>
	
	<xsl:template name="act">
		<xsl:variable name="nds_rate" select="number(params/@nds)"/>		
		<!-- <xsl:value-of select="bg:counterSet('total_nds', '0.0')"/> -->
		
		<xsl:variable name="discount" select="(number(/data/action/@summ) - number(/data/action/@cost)) div number(/data/action/@summ)"/>

		<fo:layout-master-set>
				<fo:simple-page-master margin-right="1cm"
					margin-left="2cm" margin-bottom="2cm" margin-top="0.8cm"
					page-width="21cm" page-height="29.7cm" master-name="first">
					<fo:region-body margin-top="0cm"
						margin-bottom="1.5cm" />
					<fo:region-before extent="0cm" />
					<fo:region-after extent="1.5cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
	
			<fo:page-sequence master-reference="first">	
			<fo:flow flow-name="xsl-region-body">
			
				<fo:table table-layout="fixed">
					<fo:table-column column-width="11.5cm"/>
					<fo:table-column column-width="6.3cm"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell height="1cm">
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
						
				<fo:block xsl:use-attribute-sets="text_title" space-after="3pt">
					<xsl:choose>
						<xsl:when test="/data/action/@type='1'">АКТ ПРИЕМА-ПЕРЕДАЧИ</xsl:when>
						<xsl:otherwise>АКТ ВОЗВРАТА</xsl:otherwise>
					</xsl:choose>
					№ <xsl:value-of select="format-number(/data/action/@id, '00000') "/>
					от <xsl:value-of select="/data/action/@date" />
				</fo:block>
		
				<fo:block xsl:use-attribute-sets="text_bold" text-align="center">
					карт предварительной оплаты
				</fo:block>
				
				<fo:table space-before="5pt" table-layout="fixed">
					<fo:table-column column-width="9.5cm"/>
					<fo:table-column column-width="8.5cm"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block text-align="left" xsl:use-attribute-sets="text" start-indent="1pt">г. Уфа</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block text-align="right" xsl:use-attribute-sets="text"><xsl:value-of select="/data/action/@date" /></fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>

				<fo:block space-before="5pt" xsl:use-attribute-sets="text" text-align="left" >
					Мы, нижеподписавшиеся, представитель ДИЛЕРА "<xsl:value-of select="/data/dealer/@title" />" с одной стороны
					и представитель ПРОВАЙДЕРА ООО "Бител", с другой стороны, составили настоящий Акт о том,
					что во исполнение обязательств по Договору <xsl:value-of select="/data/dealer/@contract_card"/>
					<xsl:choose>
						<xsl:when test="/data/action/@type='1'"> ПРОВАЙДЕР передает, а дилер принимает на реализацию карты для продажи третьим лицам.</xsl:when>
						<xsl:otherwise> ДИЛЕР возвращает ПРОВАЙДЕРУ карты предварительной продажи.</xsl:otherwise>
					</xsl:choose>
				</fo:block>	

				<fo:table space-before="10pt" table-layout="fixed">
					<fo:table-column column-width="1cm"/>
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="2.5cm"/>
					<fo:table-column column-width="6.0cm"/>
					<fo:table-column column-width="3.5cm"/>
					<fo:table-column column-width="3cm"/>
					<fo:table-header>
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">№</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Номинал</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Кол-во, шт.</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border" number-columns-spanned="2">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Прописью</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Сумма, руб.</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-header>
					<fo:table-body>
					<xsl:for-each select="/data/cards/group">
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"><xsl:value-of select="position()"/></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"><xsl:value-of select="@cost"/></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"><xsl:value-of select="@count"/></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border" number-columns-spanned="2">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">
									<xsl:value-of select="format-number((number(@cost)*number(@count)), '0.00')"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</xsl:for-each>
					
						<fo:table-row>
							<fo:table-cell number-columns-spanned="6" xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center" space-after="0pt">
									Серийные номера: <xsl:value-of select="/data/action/@serials"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>

						<fo:table-row>
							<fo:table-cell number-columns-spanned="4"><fo:block/></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="right" xsl:use-attribute-sets="table_text_center" space-after="0pt">
									Итого:
								</fo:block>
								<fo:block text-align="right" xsl:use-attribute-sets="table_text_center" space-before="2pt">
									Скидка:
								</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="right" xsl:use-attribute-sets="table_text_center" space-after="0pt">
									<xsl:value-of select="/data/action/@cost"/>
								</fo:block>
								<fo:block text-align="right" xsl:use-attribute-sets="table_text_center" space-before="2pt">
									<xsl:value-of select="format-number( $discount*100, '0.00')"></xsl:value-of>&#xA0;%</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell number-columns-spanned="4"><fo:block/></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="right" xsl:use-attribute-sets="table_text_center">
									Итого со скидкой:
								</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="right" xsl:use-attribute-sets="table_text_center">
									<xsl:value-of select="/data/action/@summ"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<fo:block space-before="10pt" xsl:use-attribute-sets="text" text-align="left" >
					Все передаваемые карты видимых повреждений поверхности и защитного слоя не имеют.
				</fo:block>	
				<fo:block xsl:use-attribute-sets="text" text-align="left" >
					Претензий по качеству передаваемых карт СТОРОНЫ друг к другу не имеют.
				</fo:block>	
				<fo:block space-before="5pt" xsl:use-attribute-sets="text" text-align="left" >
					Настоящий акт составлен в двух экземплярах, имеющих одинаковую юридическую силу, по одному для каждой из сторон.
				</fo:block>	
				
				<fo:table space-before="20pt" table-layout="fixed">
					<fo:table-column column-width="1.0cm"/>
					<fo:table-column column-width="8.5cm"/>
					<fo:table-column column-width="8.5cm"/>

					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">ЗАВЕРЯЮ</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">ЗАВЕРЯЮ</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" space-before="5pt">ООО "Иртелком"</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" space-before="5pt"><xsl:value-of select="/data/dealer/@title"/></fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" space-before="15pt">_____________________________/_______________/</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" space-before="15pt">_____________________________/_______________/</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" start-indent="1cm" space-before="10pt">М.П.</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" start-indent="1cm" space-before="10pt">М.П.</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<fo:table break-before="page" table-layout="fixed">
					<fo:table-column column-width="11.5cm"/>
					<fo:table-column column-width="6.5cm"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell height="1cm">
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block text-align="right" xsl:use-attribute-sets="text">Дата: <xsl:value-of select="/data/action/@date"/>
								</fo:block>
								<fo:block text-align="right" xsl:use-attribute-sets="text">№: <xsl:value-of select="/data/action/@id"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<fo:block xsl:use-attribute-sets="text_title" space-after="3pt">
					ЗАЯВКА
				</fo:block>
		
				<fo:block xsl:use-attribute-sets="text_bold" text-align="center">
					<xsl:choose>
						<xsl:when test="/data/action/@type='1'">на выдачу карт</xsl:when>
						<xsl:otherwise>на возврат карт</xsl:otherwise>
					</xsl:choose>
				</fo:block>
				
				<fo:block xsl:use-attribute-sets="text" space-before="10pt" >
					Название фирмы или наименование клиента: <xsl:value-of select="/data/dealer/@title" />
				</fo:block>
				

				<fo:table space-before="5pt" table-layout="fixed">
					<fo:table-column column-width="2cm"/>
					<fo:table-column column-width="3.5cm"/>
					<fo:table-column column-width="3.5cm"/>
					<fo:table-column column-width="4.5cm"/>
					<fo:table-column column-width="4.5cm"/>
					<fo:table-header>
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">№</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Номинал</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Кол-во, шт.</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Скидка</fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">Сумма, руб.</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-header>
					<fo:table-body>
					<xsl:for-each select="/data/cards/group">
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"><xsl:value-of select="position()"/></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"><xsl:value-of select="@cost"/></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"><xsl:value-of select="@count"/></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center"></fo:block>
							</fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center">
									<xsl:value-of select="format-number((number(@cost)*number(@count)), '0.00')"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</xsl:for-each>

						<fo:table-row>
							<fo:table-cell number-columns-spanned="5" xsl:use-attribute-sets="cell_border">
								<fo:block text-align="left" xsl:use-attribute-sets="table_text_center" space-after="0pt">
									Серийные номера: <xsl:value-of select="/data/action/@serials"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<fo:block xsl:use-attribute-sets="text" space-before="10pt" >
					Итого на сумму: <xsl:value-of select="/data/action/@summ" />
				</fo:block>
				
				<fo:table table-layout="fixed" width="100%" xsl:use-attribute-sets="text">
					<fo:table-column column-width="21em"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">
									<xsl:choose>
										<xsl:when test="/data/action/@type='1'">Передачу карт в биллинге подтверждаю</xsl:when>
										<xsl:otherwise>Возврат карт в биллинге подтверждаю</xsl:otherwise>
									</xsl:choose>
									
								</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-width="1pt">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block text-align="center" xsl:use-attribute-sets="text">(Фамилия и подпись)</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<fo:block xsl:use-attribute-sets="text" space-before="5pt" >
					Реализация дилером
				</fo:block>
				
				<fo:table table-layout="fixed" width="100%" xsl:use-attribute-sets="text">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">Фамилия менеджера: <xsl:value-of select="/data/@current_user"/></fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" text-align="right">Директор СПУ</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-width="1pt">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
			<xsl:call-template name="line"><xsl:with-param name="width" select="'100%'"/>
				<xsl:with-param name="weight" select="'2pt'"/>
				<xsl:with-param name="space-before" select="'5pt'"/>
			</xsl:call-template>
			
				<fo:table table-layout="fixed" width="100%" xsl:use-attribute-sets="text" space-before="15pt">
					<fo:table-column column-width="8em"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">Карты выдал:</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-width="1pt">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block text-align="center" xsl:use-attribute-sets="text">(Фамилия ответственного исполнителя)</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<fo:table table-layout="fixed" width="100%" xsl:use-attribute-sets="text" space-before="10pt">
					<fo:table-column column-width="9em"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">Карты получил:</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-width="1pt">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block text-align="center" xsl:use-attribute-sets="text">(Фамилия и подпись)</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
			<xsl:call-template name="line"><xsl:with-param name="width" select="'100%'"/>
				<xsl:with-param name="weight" select="'2pt'"/>
				<xsl:with-param name="space-before" select="'5pt'"/>
			</xsl:call-template>

				<fo:table table-layout="fixed" width="100%" xsl:use-attribute-sets="text" space-before="10pt">
					<fo:table-column column-width="8em"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">Примечание:</fo:block>
							</fo:table-cell>
							<fo:table-cell border-bottom-style="solid" border-width="1pt">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>

		</fo:flow>	
		</fo:page-sequence>		
	</xsl:template>	
	

	<xsl:template name="line">
	<xsl:param name="width"/>
	<xsl:param name="weight"/>
	<xsl:param name="space-before"/>
		<fo:table table-layout="fixed" width="100%"><xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute><xsl:attribute name="space-before"><xsl:value-of select="$space-before"/></xsl:attribute>
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell border-bottom-style="solid" border-bottom-width="{$weight}">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

</xsl:stylesheet>
