/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ServiceCountFilterTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    protected int serviceId;
    protected BigDecimal fromValue;
    protected BigDecimal toValue;

    public ServiceCountFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.serviceId = parameterMap.getInt("serviceId", 0);
        this.fromValue = parameterMap.getBigDecimal("fromValue", BigDecimal.ONE);
        this.toValue = parameterMap.getBigDecimal("toValue", BigDecimal.ZERO);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest tariffRequest, NPayTariffContext tariffContext) {
        int contractId = tariffRequest.contractId;
        int result = 0;
        try {
            Period period = new Period(tariffRequest.getMonthStart().getTime(), tariffRequest.getMonthEnd().getTime());
            List<ServiceObject> list = new ServiceObjectManager(tariffRequest.getConnection(), tariffRequest.moduleId).getServiceObjectList(contractId, this.serviceId, period);
            ArrayList<BigDecimal> dayCount = new ArrayList<BigDecimal>();
            IntStream.range(1, period.getLocalDateTo().getDayOfMonth() + 1).forEach(a -> dayCount.add(BigDecimal.ZERO));
            for (ServiceObject serviceObject : list) {
                if (serviceObject.getDate1() != null && serviceObject.getDate1().after(period.getDateTo()) || serviceObject.getDate2() != null && serviceObject.getDate2().before(period.getDateFrom())) continue;
                int startDay = 1;
                if (serviceObject.getDate1() != null && serviceObject.getDate1().after(period.getDateFrom())) {
                    startDay = TimeUtils.convertDateToLocalDate((Date)serviceObject.getDate1()).getDayOfMonth();
                }
                int endDay = period.getLocalDateTo().getDayOfMonth();
                if (serviceObject.getDate2() != null && serviceObject.getDate2().before(period.getDateTo())) {
                    endDay = TimeUtils.convertDateToLocalDate((Date)serviceObject.getDate2()).getDayOfMonth();
                }
                int len = dayCount.size();
                for (int index = 0; index < len; ++index) {
                    int day = index + 1;
                    if (day < startDay || day > endDay) continue;
                    dayCount.set(index, ((BigDecimal)dayCount.get(index)).add(serviceObject.getCol()));
                }
            }
            BigDecimal col = (BigDecimal)dayCount.get(tariffRequest.getTime().get(5) - 1);
            if (col.compareTo(this.fromValue) >= 0 && (this.toValue.compareTo(BigDecimal.ZERO) == 0 || col.compareTo(this.toValue) <= 0)) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

