/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.netpay.server.bean;

import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetpayUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetpayUtils.class);

    public static String getCryptoKey(String apiKey, String expireDate) {
        String cryptoKey = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(apiKey.getBytes("utf-8"));
            String md5ApiKey = Base64.getEncoder().encodeToString(digest.digest());
            digest.update((md5ApiKey + expireDate).getBytes("utf-8"));
            cryptoKey = Base64.getEncoder().encodeToString(digest.digest()).substring(0, 16);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cryptoKey;
    }

    public static String encrypt(List<String> params, String cryptoKey) {
        StringBuilder data = new StringBuilder();
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, new SecretKeySpec(cryptoKey.getBytes("utf-8"), "AES"));
            for (String text : params) {
                if (text.endsWith("=")) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(text);
                }
                if (data.length() > 0) {
                    data.append("&");
                }
                data.append(Base64.getEncoder().encodeToString(cipher.doFinal(text.getBytes("utf-8"))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("data = " + data.toString());
        }
        return data.toString();
    }

    public static Map<String, String> decrypt(String data, String cryptoKey) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, new SecretKeySpec(cryptoKey.getBytes("utf-8"), "AES"));
            for (String param : data.split("&")) {
                String[] paramArray = new String(cipher.doFinal(Base64.getDecoder().decode(param)), "utf-8").split("=");
                dataMap.put(paramArray[0], paramArray[1]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(paramArray[0] + " = " + paramArray[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }
}

