/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingType;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class HostingTypeManager {
    private Connection con;
    private String tableName;

    public HostingTypeManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_hosting_type_" + mid;
    }

    public List<HostingType> getTypeList() {
        ArrayList<HostingType> result = new ArrayList<HostingType>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public HostingType getType(int id) {
        HostingType result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getTypeFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateType(HostingType type) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, server_id, config) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, server_id=?, config=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(4, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setInt(2, type.getServerId());
            ps.setString(3, type.getConfig());
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteType(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HostingType getTypeFromRs(ResultSet rs) throws SQLException {
        HostingType result = new HostingType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setServerId(rs.getInt("server_id"));
        result.setConfig(rs.getString("config"));
        return result;
    }
}

