/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;

public class ProductSpecServiceLinkDao {
    private final Connection con;
    private final String tableName;

    public ProductSpecServiceLinkDao(Connection con, int moduleId) {
        this.con = con;
        this.tableName = moduleId > 0 ? "inv_product_spec_service_link__" + moduleId : "inv_product_spec_service_link";
    }

    protected ProductSpecServiceLink getFromRS(ResultSet rs) throws SQLException, BGException {
        ProductSpecServiceLink result = new ProductSpecServiceLink();
        result.setId(rs.getInt("id"));
        result.setProductSpecId(rs.getInt("productSpecId"));
        result.setServiceSpecId(rs.getInt("serviceSpecId"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public List<ProductSpecServiceLink> list(int productSpecId, Date date) throws BGException {
        try {
            ArrayList<ProductSpecServiceLink> result = new ArrayList<ProductSpecServiceLink>();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM " + this.tableName + " WHERE productSpecId=?");
            if (date != null) {
                sb.append(" AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ?<=dateTo)");
            }
            sb.append(" ORDER BY id");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, productSpecId);
            if (date != null) {
                java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
                ps.setDate(2, sqlDate);
                ps.setDate(3, sqlDate);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void update(int productSpecId, List<ProductSpecServiceLink> linkList) throws BGException {
        try {
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (productSpecId, serviceSpecId, dateFrom, dateTo, comment) VALUES (?,?,?,?,?)", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET dateFrom=?, dateTo=?, comment=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            for (ProductSpecServiceLink link : linkList) {
                this.update(productSpecId, link, insertPS, updatePS);
                ids.add(link.getId());
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE productSpecId=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, productSpecId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void update(int productSpecId, ProductSpecServiceLink link, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException {
        if (link.getId() > 0) {
            updatePS.setDate(1, TimeUtils.convertDateToSqlDate((Date)link.getDateFrom()));
            updatePS.setDate(2, TimeUtils.convertDateToSqlDate((Date)link.getDateTo()));
            updatePS.setString(3, link.getComment());
            updatePS.setInt(4, link.getId());
            if (updatePS.executeUpdate() == 0) {
                link.setId(-1);
            }
        }
        if (link.getId() <= 0) {
            insertPS.setInt(1, productSpecId);
            insertPS.setInt(2, link.getServiceSpecId());
            insertPS.setDate(3, TimeUtils.convertDateToSqlDate((Date)link.getDateFrom()));
            insertPS.setDate(4, TimeUtils.convertDateToSqlDate((Date)link.getDateTo()));
            insertPS.setString(5, link.getComment());
            insertPS.executeUpdate();
            link.setId(ServerUtils.lastInsertId(insertPS));
            link.setServiceSpecId(productSpecId);
        }
    }
}

