/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp.datalog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.WritableDataLog;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.DhcpDataLogReader;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.DhcpDataLogWriter;

public class DhcpDataLog
extends BGDataLog<DhcpDataLog>
implements ReadableDataLog<BGDataLogReader<?>>,
WritableDataLog<DhcpDataLogWriter> {
    public static final int DATALOG_TYPE_DHCP = 3;
    private volatile Boolean streamed;
    private volatile DhcpDataLogWriter streamedWriter;

    public DhcpDataLog(int id, File file, RandomAccessFile raf, FileChannel channel) {
        super(id, file, raf, channel, 3);
    }

    @Override
    public BGDataLogReader<?> newReader(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        return this.initReader(new DhcpDataLogReader(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DhcpDataLogWriter newWriter(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        if (this.streamed == null) {
            this.lock.lock();
            try {
                BGDataLog.Streaming streamed = this.getParameter(STREAMING);
                this.streamed = streamed != null && streamed.value > 0;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.streamed.booleanValue()) {
            return this.initWriter(new DhcpDataLogWriter(this));
        }
        this.lock.lock();
        try {
            if (this.streamedWriter == null) {
                this.streamedWriter = this.initWriter(new DhcpDataLogWriter(this){

                    @Override
                    public void flush() throws IOException {
                        ReentrantLock lock = DhcpDataLog.this.lock;
                        lock.lock();
                        try {
                            super.flush();
                        }
                        finally {
                            lock.unlock();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void writeRecord(ByteBuffer byteBuffer, long time, int[] positionArray) throws IOException {
                        ReentrantLock lock = DhcpDataLog.this.lock;
                        lock.lock();
                        try {
                            super.writeRecord(byteBuffer, time, positionArray);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
            }
            DhcpDataLogWriter dhcpDataLogWriter = this.streamedWriter;
            return dhcpDataLogWriter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.streamedWriter = null;
    }
}

