/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.ThreadContext;

public class RestrictionTrackingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Set<Integer> servTypeIds;
    private Iterator<InetServRuntime> iterator;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private ConcurrentHashMap<Integer, Boolean> resultMap = new ConcurrentHashMap();

    public RestrictionTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap params, ParameterMap defaultParams) {
        super(scheduledExecutorService, "", params, defaultParams);
        this.accounting = accounting;
        Set servTypeIds = Utils.toIntegerSet((String)params.get("servTypeIds", null));
        this.servTypeIds = servTypeIds == null || servTypeIds.size() == 0 ? null : servTypeIds;
        logger.info("Add restriction tracking worker: delay={}, batchSize={}", (Object)this.getDelay(), (Object)this.batchSize);
    }

    protected void runImpl() throws BGException {
        logger.trace("Run restriction tracker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.accounting.getInetServRuntimeMap().values().iterator();
        }
        EventProcessor ep = EventProcessor.getInstance();
        long millis = System.currentTimeMillis();
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        int count = 0;
        int size = this.batchSize;
        while (count < size && this.iterator.hasNext()) {
            InetServRuntime inetServRuntime = this.iterator.next();
            if (!this.process(this.accounting, connectionSet, ep, rootDeviceRuntime, inetServRuntime, millis, this.servTypeIds, 100L)) continue;
            ++count;
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug("Tracked " + count + " servs for " + duration + " ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Accounting accounting, ConnectionSet connectionSet, EventProcessor ep, InetDeviceRuntime rootDeviceRuntime, InetServRuntime inetServRuntime, long millis, Set<Integer> servTypeIds, long lockWaitTimeout) throws BGException {
        InetServ inetServ;
        block20: {
            inetServ = inetServRuntime.getInetServ();
            if (inetServ.getParentId() > 0) {
                return false;
            }
            if (inetServ.getDeviceState() == InetServState.STATE_DELETED.getCode()) {
                return false;
            }
            if (servTypeIds != null && !servTypeIds.contains(inetServ.getTypeId())) {
                return false;
            }
            if (!inetServRuntime.getInetServTypeRuntime().getInetServType().isNeedRestriction() || !inetServRuntime.hasRestrictions()) {
                return false;
            }
            if (rootDeviceRuntime != null && inetServ.getDeviceId() != rootDeviceRuntime.inetDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(inetServ.getDeviceId())) {
                return false;
            }
            if (!RangeUtils.inRange((long)millis, (long)millis, (long)inetServRuntime.getDateFromMillis(), (long)inetServRuntime.getDateToMillis())) {
                return false;
            }
            if (lockWaitTimeout > 0L) {
                try {
                    if (!inetServRuntime.tryLock(lockWaitTimeout, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                    break block20;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            inetServRuntime.lock();
        }
        try {
            InetTariffWorkerContext workerContext = new InetTariffWorkerContext(accounting.setup, connectionSet, accounting.moduleId);
            ThreadContext parentContext = ThreadContext.push((ThreadContext)workerContext);
            try {
                int accessCode = inetServRuntime.checkRestrictions(workerContext, accounting, null, null);
                if (accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                    if (this.resultMap.remove(inetServRuntime.inetServId) == Boolean.FALSE) {
                        EventProcessor.getInstance().publish((Event)new ContractModifiedEvent(0, inetServ.getContractId()));
                    }
                } else if (this.resultMap.putIfAbsent(inetServRuntime.inetServId, Boolean.FALSE) != Boolean.FALSE) {
                    EventProcessor.getInstance().publish((Event)new ContractModifiedEvent(0, inetServ.getContractId()));
                }
            }
            finally {
                ThreadContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
            }
        }
        finally {
            inetServRuntime.unlock();
        }
        return true;
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

