/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.radius;

import bitel.billing.server.radius.Antispam;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;

public class Radius
extends BGLogger {
    private Setup setup = Setup.getSetup();
    private RadiusProcessor<?, Nas<?, ?, ?>, ?> processor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Radius(String processorClass) {
        Application.getInstance().getCommandPortListener().setApplicationBean((Object)this);
        RadiusDictionary.reload();
        Antispam.initAntispam((ParameterMap)this.setup);
        int admin_port = this.setup.getInt("admin.port", 1899);
        String auth_host = this.setup.get("auth.host", "*");
        String acct_host = this.setup.get("acct.host", "*");
        int auth_port = this.setup.getInt("auth.port", 1812);
        int acct_port = this.setup.getInt("acct.port", 1813);
        int moduleId = this.setup.getInt("module.id", 0);
        if (moduleId <= 0) {
            moduleId = this.setup.getInt("moduleId", 0);
        }
        this.getLogger().info("Starting radius auth_port:" + auth_host + ":" + auth_port + "  acct_port:" + acct_host + ":" + acct_port + " admin_port:" + admin_port);
        try {
            new ScriptEventProcessor(this.setup).start();
            new CommonKernelEventProcessor(this.setup);
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("\tclass: " + processorClass + "\n");
        logMessage.append("\tmid: " + moduleId);
        this.getLogger().info("Init processor \n" + logMessage.toString());
        try {
            Class<?> clazz = Class.forName(processorClass);
            BGNestedContext.push((String)"processor");
            try {
                this.processor = RadiusProcessor.newInstance(clazz.asSubclass(RadiusProcessor.class), (Setup)this.setup, (int)moduleId);
            }
            catch (Exception ex) {
                this.getLogger().error("Error of init processor: " + ex.getLocalizedMessage());
                this.logError(ex);
                System.exit(1);
            }
            finally {
                BGNestedContext.pop();
            }
            this.getLogger().info("Starting authentication listener...");
            RadiusListener authListener = new RadiusListener("*".equals(auth_host) ? null : auth_host, auth_port, 524288, 0, this.processor, RadiusListener.Mode.authentication, this.setup, null, 0, 0, Boolean.FALSE);
            authListener.init();
            authListener.startListener();
            this.getLogger().info("Starting accounting listener...");
            RadiusListener acctListener = new RadiusListener("*".equals(acct_host) ? null : acct_host, acct_port, 524288, 0, this.processor, RadiusListener.Mode.accounting, this.setup, null, 0, 0, Boolean.FALSE);
            acctListener.init();
            acctListener.startListener();
        }
        catch (Throwable e) {
            this.getLogger().error(e.getMessage(), e);
        }
    }

    public String executeCommand(String command, String params) {
        String result = "UNKNOWN COMMAND!";
        if (command.equals("stop")) {
            result = "OK Stopping...";
        } else if (command.equals("gc")) {
            result = "OK GarbageCollector forsed..";
            System.gc();
        } else if (command.equals("enable_radius_log")) {
            result = "OK RADIUS log enable...";
            RadiusUtils.logEnable = true;
        } else if (command.equals("disable_radius_log")) {
            result = "OK RADIUS log disable...";
            RadiusUtils.logEnable = false;
        } else if (command.equals("status")) {
            result = this.processor.getStatus();
        } else if (command.equals("conpool")) {
            result = Setup.getSetup().getPoolStackTrace();
        } else if (command.equals("sysvar")) {
            result = Utils.getSystemVariables();
        } else if (command.equals("javavar")) {
            result = Utils.getJavaProperties();
        } else {
            String cmdResult = this.processor.executeCommand(command, params);
            if (cmdResult != null) {
                result = cmdResult;
            }
        }
        return result;
    }

    public RadiusProcessor<?, Nas<?, ?, ?>, ?> getProcessor() {
        return this.processor;
    }
}

