/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;

public class DhcpOption43 {
    private byte[] value;

    public DhcpOption43(List<DhcpOption> subOptions) {
        Objects.requireNonNull(subOptions);
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            for (DhcpOption option : subOptions) {
                buffer.write(option.code);
                buffer.write((byte)option.value.length);
                buffer.write(option.value);
            }
            this.value = buffer.toByteArray();
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }

    public DhcpOption toDhcpOption() {
        return new DhcpOption(43, this.value);
    }
}

