/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.graphics;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.bitel.bgbilling.kernel.map.bean.MapMarker;
import ru.bitel.bgbilling.kernel.map.bean.PointPair;
import ru.bitel.bgbilling.kernel.map.graphics.AbstractRoutePainter;

public class PointPairsRoutePainter
extends AbstractRoutePainter {
    private final List<PointPair> pairs;

    public PointPairsRoutePainter(List<PointPair> pairs) {
        this.pairs = pairs;
    }

    @Override
    public void drawRoute(Graphics2D g, JXMapViewer map) {
        for (PointPair pair : this.pairs) {
            MapMarker first = pair.getFirstPoint();
            MapMarker second = pair.getSecondPoint();
            if (first == null || second == null) continue;
            Point2D firstPoint2D = map.getTileFactory().geoToPixel((GeoPosition)first, map.getZoom());
            Point2D secondPoint2D = map.getTileFactory().geoToPixel((GeoPosition)second, map.getZoom());
            g.drawLine((int)firstPoint2D.getX(), (int)firstPoint2D.getY(), (int)secondPoint2D.getX(), (int)secondPoint2D.getY());
        }
    }
}

