/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import ru.bitel.bgbilling.modules.ipn.common.bean.BGDecimalFormat;

public class GraphPanel
extends JPanel {
    int rowWidth = 10;
    long[] grafDataValue = null;
    int[] grafDataNormValue = null;
    String[] labels = null;
    int widthIndent = 25;
    int heightIndent = 20;
    int graphicsWidth = 0;
    int graphicsHeight = 0;
    int oX = this.widthIndent;
    int oY = this.heightIndent;
    Color color = Color.blue;
    Font font11 = new Font("", 0, 11);
    Font font13 = new Font("", 1, 13);
    DecimalFormat format1 = new BGDecimalFormat("###,###,###,##0.0");
    DecimalFormat format2 = new BGDecimalFormat("###,###,###,###.##");
    long max = 0L;
    long curMax = 0L;
    long all = 0L;
    int unit = 0x100000;
    int items = -1;

    public void setData(int items, long[] grafDataValue, String[] labels) {
        if (items == -1 || grafDataValue == null || labels == null) {
            return;
        }
        this.items = items;
        this.grafDataValue = grafDataValue;
        this.labels = labels;
        this.max = 1L;
        this.all = 0L;
        this.grafDataNormValue = new int[items];
        for (int i = 0; i < items; ++i) {
            this.all += grafDataValue[i];
            if (grafDataValue[i] <= this.max) continue;
            this.max = grafDataValue[i];
        }
        this.repaint();
    }

    public void setUnit(int unit) {
        this.unit = unit;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int i;
        if (this.items == -1) {
            return;
        }
        FontMetrics FM11 = g.getFontMetrics(this.font11);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.curMax = this.max;
        if (this.max % (long)this.unit != 0L) {
            this.curMax = (long)this.unit * (this.max / (long)this.unit + 1L);
        }
        this.oX = this.widthIndent;
        this.graphicsHeight = this.getSize().height - 3 * this.heightIndent;
        this.oY = this.getSize().height - this.heightIndent;
        int gridHeight = this.graphicsHeight / 10;
        for (i = 0; i < this.items; ++i) {
            this.grafDataNormValue[i] = (int)((float)this.grafDataValue[i] / (float)this.curMax * (float)this.graphicsHeight);
        }
        g.setColor(Color.darkGray);
        g.setFont(this.font11);
        this.graphicsWidth = this.getSize().width - 2 * this.widthIndent;
        this.rowWidth = this.graphicsWidth / this.items;
        for (i = 0; i < this.items; ++i) {
            int w2 = FM11.stringWidth(this.labels[i]) / 2;
            g.drawString(this.labels[i], this.oX + i * this.rowWidth - w2 + this.rowWidth / 2, this.oY + FM11.getHeight());
        }
        g.setFont(this.font13);
        g.drawString("\u0412\u0441\u0435\u0433\u043e: " + this.format((double)this.all / (double)this.unit), this.oX, this.oY - this.graphicsHeight - 10);
        g.setColor(Color.black);
        g.drawRect(this.oX, this.oY - this.graphicsHeight, this.graphicsWidth, this.graphicsHeight);
        for (i = 1; i < 10; ++i) {
            g.drawLine(this.oX, this.oY - i * gridHeight, this.oX + this.graphicsWidth, this.oY - i * gridHeight);
        }
        g.setColor(this.color);
        for (i = 0; i < this.items; ++i) {
            g.fillRect(this.oX + i * this.rowWidth + 2, this.oY - this.grafDataNormValue[i], this.rowWidth - 4, this.grafDataNormValue[i]);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int r;
        String txt = super.getToolTipText(e);
        int x = e.getX() - this.oX;
        int y = this.oY - e.getY();
        if (x >= 0 && x <= this.graphicsWidth && y >= 0 && y <= this.graphicsHeight && (r = x / this.rowWidth) < this.items && y < this.grafDataNormValue[r]) {
            txt = this.format((double)this.grafDataValue[r] / (double)this.unit);
        }
        return txt;
    }

    private String format(double value) {
        Object txt = this.format2.format(value);
        if (this.unit == 1) {
            txt = (String)txt + " \u0431\u0430\u0439\u0442";
        } else if (this.unit == 1024) {
            txt = (String)txt + " \u041a\u0431\u0430\u0439\u0442";
        } else if (this.unit == 0x100000) {
            txt = (String)txt + " \u041c\u0431\u0430\u0439\u0442";
        } else if (this.unit == 0x40000000) {
            txt = (String)txt + " \u0413\u0431\u0430\u0439\u0442";
        }
        return txt;
    }
}

