/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.traffic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.modules.dialup.server.DetailCompressRules;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SessionTrafficCache {
    private Map<Integer, SessionData> data = new HashMap<Integer, SessionData>();

    public SessionData getSessionData(int sessionId) {
        return this.data.get(sessionId);
    }

    public void addSessionData(int sessionId, SessionData sessionData) {
        this.data.put(sessionId, sessionData);
    }

    public void flushCache(Connection con, int mid, Calendar day) throws Exception {
        String sessionDetailTable = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)day.getTime(), (int)mid);
        if (ServerUtils.tableExists((Connection)con, (String)sessionDetailTable)) {
            String query = null;
            query = "INSERT INTO " + sessionDetailTable + " (sid, amount, dtime, session_id, cid) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement psInsert = con.prepareStatement(query);
            for (Map.Entry<Integer, SessionData> sessionEntry : this.data.entrySet()) {
                int sessionId = sessionEntry.getKey();
                SessionData session = sessionEntry.getValue();
                query = "DELETE FROM " + sessionDetailTable + " WHERE session_id=? AND dtime>=? AND dtime<? AND sid IN (" + session.getFullServiceList() + ")";
                PreparedStatement psDelete = con.prepareStatement(query);
                psDelete.setInt(1, sessionId);
                psDelete.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)day));
                psDelete.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getNextDay((Calendar)day)));
                psDelete.executeUpdate();
                psDelete.close();
                psInsert.setInt(4, sessionId);
                psInsert.setInt(5, session.getContractId());
                session.calcDependTrafics();
                this.flushTraffics(day, psInsert, session.getIndependTraffics());
                this.flushTraffics(day, psInsert, session.getDependTraffics());
            }
            psInsert.close();
        }
        this.data.clear();
    }

    private void flushTraffics(Calendar dayHour, PreparedStatement psInsert, Map<Integer, Map<Integer, Long>> traffics) throws SQLException {
        dayHour = (Calendar)dayHour.clone();
        for (Map.Entry<Integer, Map<Integer, Long>> hourData : traffics.entrySet()) {
            int hour = hourData.getKey();
            dayHour.set(11, hour);
            TimeUtils.clear_MIN_MIL_SEC((Calendar)dayHour);
            psInsert.setTimestamp(3, TimeUtils.convertCalendarToTimestamp((Calendar)dayHour));
            Map<Integer, Long> serviceTraffics = hourData.getValue();
            for (Map.Entry<Integer, Long> serviceAmount : serviceTraffics.entrySet()) {
                psInsert.setInt(1, serviceAmount.getKey());
                psInsert.setLong(2, serviceAmount.getValue());
                psInsert.executeUpdate();
            }
        }
    }

    public static class SessionData {
        private int contractId;
        private List<Traffic> trafficConfig;
        private DetailCompressRules compressRules;
        private Set<Integer> netFlowServices = new HashSet<Integer>(5);
        private String fullServiceList;
        private Map<Integer, Map<Integer, Long>> independTraffics = new HashMap<Integer, Map<Integer, Long>>();
        private Map<Integer, Map<Integer, Long>> dependTraffics = new HashMap<Integer, Map<Integer, Long>>();

        public SessionData(int contractId, List<Traffic> trafficConfig, DetailCompressRules compressRules) {
            this.contractId = contractId;
            this.trafficConfig = trafficConfig;
            this.compressRules = compressRules;
            for (Traffic traffic : trafficConfig) {
                if (traffic.getTrafficSource() != 3) continue;
                this.netFlowServices.add(traffic.getServiceId());
            }
            ArrayList<Integer> fullServiceList = new ArrayList<Integer>();
            if (this.netFlowServices.size() == 0) {
                fullServiceList.add(0);
            }
            fullServiceList.addAll(this.netFlowServices);
            for (Traffic traffic : trafficConfig) {
                boolean fullDepend;
                if (traffic.getTrafficSource() != 5 && traffic.getTrafficSource() != 6 || !(fullDepend = !(!this.netFlowServices.contains(traffic.getParamSID_1()) || !this.netFlowServices.contains(traffic.getParamSID_2()) || traffic.getParamSID_3() > 0 && !this.netFlowServices.contains(traffic.getParamSID_3()) || traffic.getParamSID_4() > 0 && !this.netFlowServices.contains(traffic.getParamSID_4())))) continue;
                fullServiceList.add(traffic.getServiceId());
            }
            this.fullServiceList = Utils.toString(fullServiceList);
        }

        public void calcDependTrafics() {
            this.dependTraffics.clear();
            for (Traffic traffic : this.trafficConfig) {
                Map<Integer, Long> trafficValues;
                int hour;
                long amount;
                if (traffic.getTrafficSource() == 5) {
                    for (Map.Entry<Integer, Map<Integer, Long>> hourMap : this.independTraffics.entrySet()) {
                        amount = 0L;
                        hour = hourMap.getKey();
                        trafficValues = hourMap.getValue();
                        amount = Math.max(Utils.maskNull((Long)trafficValues.get(traffic.getParamSID_1())), Utils.maskNull((Long)trafficValues.get(traffic.getParamSID_2())));
                        if (amount <= 0L) continue;
                        this.addDependAmount(this.dependTraffics, traffic.getServiceId(), hour, amount);
                    }
                    continue;
                }
                if (traffic.getTrafficSource() != 6) continue;
                for (Map.Entry<Integer, Map<Integer, Long>> hourMap : this.independTraffics.entrySet()) {
                    amount = 0L;
                    hour = hourMap.getKey();
                    trafficValues = hourMap.getValue();
                    amount += Utils.maskNull((Long)trafficValues.get(traffic.getParamSID_1())).longValue();
                    amount += Utils.maskNull((Long)trafficValues.get(traffic.getParamSID_2())).longValue();
                    amount += Utils.maskNull((Long)trafficValues.get(traffic.getParamSID_3())).longValue();
                    if ((amount += Utils.maskNull((Long)trafficValues.get(traffic.getParamSID_4())).longValue()) <= 0L) continue;
                    this.addDependAmount(this.dependTraffics, traffic.getServiceId(), hour, amount);
                }
            }
        }

        private void addDependAmount(Map<Integer, Map<Integer, Long>> dependTraffics, int sid, int hour, long value) {
            Long amount;
            Map<Integer, Long> hourTraffics = dependTraffics.get(hour);
            if (hourTraffics == null) {
                hourTraffics = new HashMap<Integer, Long>();
                dependTraffics.put(hour, hourTraffics);
            }
            if ((amount = hourTraffics.get(sid)) == null) {
                amount = 0L;
            }
            amount = amount + value;
            hourTraffics.put(sid, value);
        }

        public void addAmount(int sid, int hour, long value) {
            if (this.netFlowServices.contains(sid)) {
                Long amount;
                if ((hour = this.compressRules.getRecordHour(hour, sid)) < 0) {
                    return;
                }
                Map<Integer, Long> hourTraffics = this.independTraffics.get(hour);
                if (hourTraffics == null) {
                    hourTraffics = new HashMap<Integer, Long>();
                    this.independTraffics.put(hour, hourTraffics);
                }
                if ((amount = hourTraffics.get(sid)) == null) {
                    amount = 0L;
                }
                amount = amount + value;
                hourTraffics.put(sid, amount);
            }
        }

        public Set<Integer> getNetFlowServices() {
            return this.netFlowServices;
        }

        public Map<Integer, Map<Integer, Long>> getIndependTraffics() {
            return this.independTraffics;
        }

        public Map<Integer, Map<Integer, Long>> getDependTraffics() {
            return this.dependTraffics;
        }

        public String getFullServiceList() {
            return this.fullServiceList;
        }

        public int getContractId() {
            return this.contractId;
        }
    }
}

