/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;

public class ProductDao
extends AbstractIdDao<Product> {
    public ProductDao(Connection con) {
        super(con, 0, "inv_product");
    }

    private Product getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        return Product.builder().setId(rs.getInt("id")).setContractId(rs.getInt("contractId")).setAccountId(rs.getInt("accountId")).setProductSpecId(rs.getInt("productSpecId")).setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeFrom"))).setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeTo"))).setActivationModeId(rs.getInt("activationModeId")).setActivationTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activationTime"))).setActivationPrice(rs.getBigDecimal("activationPrice")).setDeactivationTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("deactivationTime"))).setUserId(rs.getInt("userId")).setDeviceProductId(rs.getString("deviceProductId")).setDeviceState(rs.getShort("deviceState")).setComment(rs.getString("comment")).setDescription(rs.getString("description")).setProductSpecTitle(titleLoad ? rs.getString("spec.title") : "").build();
    }

    protected Product getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    protected void updateImpl(Product product) throws BGException, SQLException {
        if (product.getId() <= 0) {
            if (product.getActivationTime() == null) {
                product.setActivationTime(new Date());
            }
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (contractId, accountId, productSpecId, activationModeId, timeFrom, timeTo, activationTime, activationPrice,  deactivationTime, userId, deviceProductId, deviceState, comment, description) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setInt(1, product.getContractId());
            ps.setInt(2, product.getAccountId());
            ps.setInt(3, product.getProductSpecId());
            ps.setInt(4, product.getActivationModeId());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeFrom()));
            ps.setTimestamp(6, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeTo()));
            ps.setTimestamp(7, TimeUtils.convertDateToTimestampSeconds((Date)product.getActivationTime()));
            ps.setBigDecimal(8, product.getActivationPrice());
            ps.setTimestamp(9, TimeUtils.convertDateToTimestampSeconds((Date)product.getDeactivationTime()));
            ps.setInt(10, product.getUserId());
            ps.setString(11, product.getDeviceProductId());
            ps.setShort(12, product.getDeviceState());
            ps.setString(13, Utils.maskNull((String)product.getComment()));
            ps.setString(14, Utils.maskNull((String)product.getDescription()));
            ps.executeUpdate();
            product.setId(ServerUtils.lastInsertId(ps));
            ps.close();
        } else {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET activationModeId=?, timeFrom=?, timeTo=?, deactivationTime=?, userId=?, comment=?, description=?, activationPrice=? WHERE id=?");
            ps.setInt(1, product.getActivationModeId());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeFrom()));
            ps.setTimestamp(3, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeTo()));
            ps.setTimestamp(4, TimeUtils.convertDateToTimestampSeconds((Date)product.getDeactivationTime()));
            ps.setInt(5, product.getUserId());
            ps.setString(6, Utils.maskNull((String)product.getComment()));
            ps.setString(7, Utils.maskNull((String)product.getDescription()));
            ps.setBigDecimal(8, product.getActivationPrice());
            ps.setInt(9, product.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Product product, boolean customer) throws BGException {
        block11: {
            try {
                if (product.getTimeTo() != null) {
                    PreparedStatement ps = customer ? this.con.prepareStatement("UPDATE " + this.tableName + " SET timeTo=?, deactivationTime=? WHERE id=? AND timeTo IS NULL") : this.con.prepareStatement("UPDATE " + this.tableName + " SET timeTo=?, deactivationTime=? WHERE id=?");
                    ps.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeTo()));
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeTo()));
                    ps.setInt(3, product.getId());
                    try {
                        if (ps.executeUpdate() == 0) {
                            throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.");
                        }
                        break block11;
                    }
                    finally {
                        ps.close();
                    }
                }
                PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET timeTo=?, deactivationTime=? WHERE id=? AND (timeTo IS NOT NULL AND deactivationTime IS NOT NULL)");
                ps.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds((Date)product.getTimeTo()));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((Date)product.getDeactivationTime()));
                ps.setInt(3, product.getId());
                try {
                    if (ps.executeUpdate() == 0) {
                        throw new BGMessageException("\u042d\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0435\u043b\u044c\u0437\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c!");
                    }
                }
                finally {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public List<Product> list(int moduleId, int contractId, int accountId, boolean kernel, Date time) throws BGException {
        return this.list(moduleId, contractId, accountId, kernel, null, null, time, time, true, true);
    }

    public List<Product> list(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date timeFromIntersect, Date timeToIntersect, boolean needNonActive, boolean titleLoad) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        ArrayList<Product> result = new ArrayList<Product>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT product.*, spec.title FROM ").append(this.tableName).append(" AS product");
        sb.append(" LEFT JOIN inv_product_spec as spec ON product.productSpecId=spec.id ");
        sb.append(" WHERE product.contractId=? AND (? OR product.accountId=?) AND ((? OR spec.moduleId=?) OR (? AND spec.moduleId=0))");
        sb.append(" AND (? OR product.timeFrom>=?)");
        sb.append(" AND (? OR product.timeTo<=?)");
        sb.append(" AND (? OR product.timeFrom IS NULL OR product.timeFrom<=?)");
        sb.append(" AND (? OR product.timeTo IS NULL OR product.timeTo>=?)");
        if (!needNonActive) {
            sb.append("\n AND (product.timeTo IS NULL OR product.timeFrom<product.timeTo)");
        }
        sb.append("\n ORDER BY product.timeFrom");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            ps.setInt(1, contractId);
            ps.setBoolean(2, accountId <= 0);
            ps.setInt(3, accountId);
            ps.setBoolean(4, moduleId < 0);
            ps.setInt(5, moduleId);
            ps.setBoolean(6, kernel);
            ps.setBoolean(7, timeFrom == null);
            ps.setTimestamp(8, TimeUtils.convertDateToTimestamp((Date)timeFrom));
            ps.setBoolean(9, timeTo == null);
            ps.setTimestamp(10, TimeUtils.convertDateToTimestamp((Date)timeTo));
            ps.setBoolean(11, timeToIntersect == null);
            ps.setTimestamp(12, TimeUtils.convertDateToTimestamp((Date)timeToIntersect));
            ps.setBoolean(13, timeFromIntersect == null);
            ps.setTimestamp(14, TimeUtils.convertDateToTimestamp((Date)timeFromIntersect));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, titleLoad));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public int delete(int contractId, int id) throws Exception {
        return this.delete("contractId=? AND id=?", new Object[]{contractId, id});
    }

    public void updateDeviceState(int contractId, int tvAccountId, int productId, String deviceProductId, short deviceState) throws BGException {
        block17: {
            if (deviceProductId == null || deviceProductId.length() == 0) {
                String query = "UPDATE " + this.tableName + " SET deviceState=? WHERE contractId=? AND id=? AND deviceState!=?";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    int index = 1;
                    ps.setShort(index++, deviceState);
                    ps.setInt(index++, contractId);
                    ps.setInt(index++, productId);
                    ps.setShort(index++, deviceState);
                    ps.executeUpdate();
                    break block17;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            String query = "UPDATE " + this.tableName + " SET deviceProductId=?, deviceState=? WHERE contractId=? AND id=? AND (deviceState!=? OR deviceProductId!=?)";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, deviceProductId);
                ps.setShort(index++, deviceState);
                ps.setInt(index++, contractId);
                ps.setInt(index++, productId);
                ps.setShort(index++, deviceState);
                ps.setString(index++, deviceProductId);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public Product get(int contractId, int id) throws BGException {
        Product result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE contractId=? AND id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Product getAndDelete(int contractId, int id) throws Exception {
        Product old = this.get(contractId, id);
        this.delete(contractId, id);
        return old;
    }

    public void checkProductSpecDelete(int productSpecId) throws BGException {
        String query = "SELECT * FROM " + this.tableName + " WHERE productSpecId=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, productSpecId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442, \u0442.\u043a. \u043e\u043d \u0431\u044b\u043b \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.", "productSpec.cantDelete.activeProducts");
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void checkProductSpecActivationModeDelete(int activationModeId) throws BGException {
        String query = "SELECT * FROM " + this.tableName + " WHERE activationModeId=? AND (timeTo IS NULL OR timeTo>=NOW()) LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, activationModeId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 [" + activationModeId + "], \u0442.\u043a. \u043e\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.", "productSpec.cantDelete.activeProducts");
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Product> listEnd(List<Integer> productSpecIds, LocalDate now, int daysBack) throws BGException {
        return this.list("true" + (String)(productSpecIds != null && !productSpecIds.isEmpty() ? " AND productSpecId IN ( " + Utils.toString(productSpecIds) + " )" : "") + " AND timeTo<? AND timeTo>?", null, new Object[]{TimeUtils.convertLocalDateToSqlDate((LocalDate)now), TimeUtils.convertLocalDateToSqlDate((LocalDate)now.minusDays(daysBack))});
    }
}

