/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;

public class PasswordManager {
    protected Connection con;
    private Random random;

    public PasswordManager(Connection con) {
        this.con = con;
    }

    public String findContractTitle(String passwordOnce) {
        String contractTitle = null;
        if (passwordOnce != null) {
            try {
                int index = 1;
                String query = null;
                ResultSet resultSet = null;
                PreparedStatement ps = null;
                query = "SELECT contract_title FROM contract_password_once WHERE password=?";
                ps = this.con.prepareStatement(query.toString());
                ps.setString(index++, passwordOnce);
                resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    contractTitle = resultSet.getString(1);
                }
                resultSet.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return contractTitle;
    }

    public void addPassword(String contractTitle, long passwordExpireHour, String password) {
        if (contractTitle != null && password != null) {
            try {
                int index = 1;
                String query = null;
                PreparedStatement ps = null;
                Date now = new Date();
                query = "INSERT INTO contract_password_once SET dt=?, contract_title=?, password=?";
                ps = this.con.prepareStatement(query);
                ps.setTimestamp(index++, new Timestamp(now.getTime() + passwordExpireHour * 3600000L));
                ps.setString(index++, contractTitle);
                ps.setString(index++, password);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteContractTitle(String passwordOnce) {
        if (passwordOnce != null) {
            try {
                int index = 1;
                String query = null;
                PreparedStatement ps = null;
                query = "DELETE FROM contract_password_once WHERE password=?";
                ps = this.con.prepareStatement(query.toString());
                ps.setString(index++, passwordOnce);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteByContract(String contractTitle) {
        if (contractTitle != null) {
            try {
                int index = 1;
                String query = null;
                PreparedStatement ps = null;
                query = "DELETE FROM contract_password_once WHERE contract_title=?";
                ps = this.con.prepareStatement(query.toString());
                ps.setString(index++, contractTitle);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getOncePassword(String charArray) {
        if (this.random == null) {
            this.random = new Random();
        }
        StringBuilder builder = new StringBuilder();
        int l = charArray.length();
        for (int i = 0; i < 32; ++i) {
            builder.append(charArray.charAt(this.random.nextInt(l)));
        }
        return builder.toString();
    }
}

