/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.TariffLabelTree;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanel;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelTreeCellRenderer;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.client.action.BGUAction;

public class TariffLabelPanel
extends BGUPanel {
    private TariffPanel tariffPanel;
    private String mode = "filter";
    private JPanel labelModePanel = null;
    TariffLabelTree filterLabelTree = new TariffLabelTree();
    JPopupMenu popupFilterMenu = new JPopupMenu();
    private JPopupMenu popupEditorMenu = new JPopupMenu();
    private BGUPanel.WebServiceHolder<TariffService> tariffService = new BGUPanel.WebServiceHolder(TariffService.class, 0);

    public TariffLabelPanel(TariffPanel tariffPanel) {
        super(tariffPanel.getContext());
        this.setLayout(new GridBagLayout());
        this.tariffPanel = tariffPanel;
        this.build();
    }

    private TreePath getSelectionPath(TariffLabelTree filterLabelTree, String message) {
        TreePath treePath = filterLabelTree.getSelectionPath();
        if (treePath == null) {
            ClientUtils.showErrorMessageDialog(message);
        }
        return treePath;
    }

    @Override
    protected void jbInit() throws Exception {
        new TreeDragSource(this.filterLabelTree, 2);
        new TreeDropTarget(this.filterLabelTree);
        this.initFilterLabelTree();
        ButtonGroup modeButtonGroup = new ButtonGroup();
        ActionListener modeActionListener = event -> {
            this.mode = event.getActionCommand();
            this.switchLabelMode(this.mode);
        };
        this.labelModePanel = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (int index = 0; index < this.getComponentCount(); ++index) {
                    this.getComponent(index).setEnabled(enabled);
                }
            }
        };
        this.labelModePanel.add((Component)new JLabel("\u041c\u0435\u0442\u043a\u0438:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.labelModePanel.add((Component)new ModeButton("filter", modeButtonGroup, modeActionListener, "\u0424\u0438\u043b\u044c\u0442\u0440"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.labelModePanel.add((Component)new ModeButton("editor", modeButtonGroup, modeActionListener, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        modeButtonGroup.setSelected(modeButtonGroup.getElements().nextElement().getModel(), true);
        int y = 0;
        this.add((Component)this.labelModePanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(this.filterLabelTree), new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.popupEditorMenu.add(new JMenuItem(new BGUAction("addTarifLabel", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode tariffLabelTreeNode;
                Object userObject;
                Object selectedObject;
                TreePath treePath = TariffLabelPanel.this.getSelectionPath(TariffLabelPanel.this.filterLabelTree, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0443\u044e \u043c\u0435\u0442\u043a\u0443.");
                if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = (tariffLabelTreeNode = (DefaultMutableTreeNode)selectedObject).getUserObject()) instanceof TariffLabelItem) {
                    TariffLabelItem newTariffLabelItem = new TariffLabelItem();
                    newTariffLabelItem.setId(-1);
                    newTariffLabelItem.setParentId(((TariffLabelItem)userObject).getId());
                    newTariffLabelItem.setTitle("\u041d\u043e\u0432\u0430\u044f \u043c\u0435\u0442\u043a\u0430");
                    DefaultMutableTreeNode newTariffLabelTreeNode = new DefaultMutableTreeNode();
                    newTariffLabelTreeNode.setUserObject(newTariffLabelItem);
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)TariffLabelPanel.this.filterLabelTree.getModel();
                    defaultTreeModel.insertNodeInto(newTariffLabelTreeNode, tariffLabelTreeNode, tariffLabelTreeNode.getChildCount());
                    TariffLabelPanel.this.filterLabelTree.expandPath(new TreePath(tariffLabelTreeNode.getPath()));
                    TariffLabelPanel.this.filterLabelTree.scrollPathToVisible(new TreePath(tariffLabelTreeNode.getPath()));
                    TariffLabelPanel.this.tryCall(() -> newTariffLabelItem.setId(TariffLabelPanel.this.tariffService.get().updateTariffLabelTreeItem(newTariffLabelItem)));
                }
            }
        }));
        this.popupEditorMenu.add(new JMenuItem(new BGUAction("renameTarifLabel", "\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u043c\u0435\u0442\u043a\u0443"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath treePath = TariffLabelPanel.this.getSelectionPath(TariffLabelPanel.this.filterLabelTree, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0435\u0442\u043a\u0443.");
                if (treePath != null) {
                    TariffLabelPanel.this.filterLabelTree.startEditingAtPath(treePath);
                }
            }
        }));
        this.popupEditorMenu.add(new JMenuItem(new BGUAction("dropTarifLabel", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedObject;
                TreePath treePath = TariffLabelPanel.this.getSelectionPath(TariffLabelPanel.this.filterLabelTree, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0435\u0442\u043a\u0443.");
                if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode tariffLabelTreeNode = (DefaultMutableTreeNode)selectedObject;
                    if (tariffLabelTreeNode.isRoot()) {
                        ClientUtils.showErrorMessageDialog("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f.");
                    } else if (!tariffLabelTreeNode.isLeaf()) {
                        ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f, \u0442.\u043a. \u043c\u0435\u0442\u043a\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    } else {
                        Object userObject = tariffLabelTreeNode.getUserObject();
                        if (userObject instanceof TariffLabelItem) {
                            boolean removeFlag = true;
                            TariffLabelItem tariffLabelItem = (TariffLabelItem)userObject;
                            int tariffCount = tariffLabelItem.getTariffLinkCount();
                            if (tariffCount > 0) {
                                boolean bl = removeFlag = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041c\u0435\u0442\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0442\u0430\u0440\u0438\u0444\u0430\u0445 (" + tariffCount + ").\n\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435.", "\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f", 0) == 0;
                            }
                            if (removeFlag) {
                                ((DefaultTreeModel)TariffLabelPanel.this.filterLabelTree.getModel()).removeNodeFromParent(tariffLabelTreeNode);
                                TariffLabelPanel.this.tryCall(() -> TariffLabelPanel.this.tariffService.get().removeTariffLabelTreeItem(tariffLabelItem.getId()));
                            }
                        }
                    }
                }
            }
        }));
        this.popupFilterMenu.add(new JMenuItem(new BGUAction("selectParent", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435\u0445 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u0435\u0439"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JMenuItem menuItem = (JMenuItem)event.getSource();
                TariffLabelTree tree = (TariffLabelTree)((JPopupMenu)menuItem.getParent()).getInvoker();
                Object selectedObject = tree.getLastSelectedPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    for (DefaultMutableTreeNode tariffLabelTreeNode = (DefaultMutableTreeNode)selectedObject; tariffLabelTreeNode != null; tariffLabelTreeNode = (DefaultMutableTreeNode)tariffLabelTreeNode.getParent()) {
                        Object userObject = tariffLabelTreeNode.getUserObject();
                        if (!(userObject instanceof TariffLabelItem)) continue;
                        ((TariffLabelItem)userObject).setSelected(true);
                        ((DefaultTreeModel)tree.getModel()).nodeChanged(tariffLabelTreeNode);
                    }
                }
                tree.firePropertyChange("changeSelected", false, true);
            }
        }));
        this.popupFilterMenu.add(new JMenuItem(new BGUAction("selectChildren", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435\u0445 \u0434\u0435\u0442\u0435\u0439"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JMenuItem menuItem = (JMenuItem)event.getSource();
                TariffLabelTree tree = (TariffLabelTree)((JPopupMenu)menuItem.getParent()).getInvoker();
                Object selectedObject = tree.getLastSelectedPathComponent();
                if (selectedObject instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode tariffLabelTreeNode = (DefaultMutableTreeNode)selectedObject;
                    int selectNodeLevel = tariffLabelTreeNode.getLevel();
                    while (tariffLabelTreeNode != null) {
                        Object userObject = tariffLabelTreeNode.getUserObject();
                        if (userObject instanceof TariffLabelItem) {
                            ((TariffLabelItem)userObject).setSelected(true);
                            ((DefaultTreeModel)tree.getModel()).nodeChanged(tariffLabelTreeNode);
                        }
                        if ((tariffLabelTreeNode = tariffLabelTreeNode.getNextNode()) == null || tariffLabelTreeNode.getLevel() > selectNodeLevel) continue;
                        break;
                    }
                }
                tree.firePropertyChange("changeSelected", false, true);
            }
        }));
        this.popupFilterMenu.add(new JMenuItem(new BGUAction("selectReset", "\u0421\u0431\u0440\u043e\u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JMenuItem menuItem = (JMenuItem)event.getSource();
                TariffLabelTree tree = (TariffLabelTree)((JPopupMenu)menuItem.getParent()).getInvoker();
                for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)tree.getModel().getRoot()).getNextNode(); node != null; node = node.getNextNode()) {
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof TariffLabelItem)) continue;
                    ((TariffLabelItem)userObject).setSelected(false);
                    ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
                }
                tree.firePropertyChange("changeSelected", false, true);
            }
        }));
    }

    public void setLabelTreeData() {
        this.setLabelTreeData(this.filterLabelTree, -1);
    }

    private void setLabelTreeData(TariffLabelTree labelTree, int tariffPlanId) {
        List<TariffLabelItem> data = new ArrayList<TariffLabelItem>();
        try {
            data = this.tariffService.get().getTariffLabelTreeItemList(tariffPlanId);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        labelTree.setData(data);
    }

    public void updateFilterLabelTreeData(List<TariffLabelItem> items) {
        DefaultTreeModel model = (DefaultTreeModel)this.filterLabelTree.getModel();
        block0: for (TariffLabelItem tariffLabelItem : items) {
            for (DefaultMutableTreeNode tariffLabelTreeNode = (DefaultMutableTreeNode)model.getRoot(); tariffLabelTreeNode != null; tariffLabelTreeNode = tariffLabelTreeNode.getNextNode()) {
                TariffLabelItem item;
                Object object = tariffLabelTreeNode.getUserObject();
                if (!(object instanceof TariffLabelItem) || (item = (TariffLabelItem)object).getId() != tariffLabelItem.getId()) continue;
                item.setTitle(tariffLabelItem.getTitle());
                item.setTariffLinkCount(tariffLabelItem.getTariffLinkCount());
                model.nodeChanged(tariffLabelTreeNode);
                continue block0;
            }
        }
    }

    private void initFilterLabelTree() {
        this.filterLabelTree.addPropertyChangeListener(e -> {
            if ("changeSelected".equals(e.getPropertyName())) {
                this.tariffPanel.initPages();
                this.tariffPanel.trySetData();
            }
        });
        TreeCellEditor treeCellEditor = new TreeCellEditor(){
            private Object editValue;

            @Override
            public boolean stopCellEditing() {
                return true;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                boolean result;
                boolean bl = result = anEvent == null;
                if (!result) {
                    DefaultMutableTreeNode tariffLabelTreeNode;
                    MouseEvent mouseEvent;
                    TreePath treePath;
                    Object selectedObject;
                    TariffLabelTree tree = (TariffLabelTree)anEvent.getSource();
                    if (anEvent instanceof MouseEvent && (selectedObject = (treePath = tree.getPathForLocation((mouseEvent = (MouseEvent)anEvent).getX(), mouseEvent.getY())).getLastPathComponent()) instanceof DefaultMutableTreeNode && (tariffLabelTreeNode = (DefaultMutableTreeNode)selectedObject).isRoot()) {
                        result = false;
                    }
                }
                return result;
            }

            @Override
            public Object getCellEditorValue() {
                return this.editValue;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
            }

            @Override
            public Component getTreeCellEditorComponent(final JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
                final JTextField comp = new JTextField();
                comp.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            TariffLabelItem tariffLabelItem = (TariffLabelItem)editValue;
                            tariffLabelItem.setTitle(comp.getText());
                            TariffLabelPanel.this.tryCall(() -> TariffLabelPanel.this.tariffService.get().updateTariffLabelTreeItem(tariffLabelItem));
                            tree.stopEditing();
                            TariffLabelPanel.this.setLabelTreeData(TariffLabelPanel.this.filterLabelTree, -1);
                        }
                    }
                });
                if (value instanceof DefaultMutableTreeNode) {
                    this.editValue = ((DefaultMutableTreeNode)value).getUserObject();
                    comp.setText(((TariffLabelItem)this.editValue).getGuiTitle());
                    comp.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
                }
                comp.repaint();
                return row > 0 ? comp : null;
            }
        };
        DefaultTreeCellEditor e2 = new DefaultTreeCellEditor(this.filterLabelTree, new DefaultTreeCellRenderer(){
            {
                this.setOpenIcon(ClientUtils.getIcon("node.png"));
                this.setClosedIcon(ClientUtils.getIcon("node.png"));
                this.setLeafIcon(ClientUtils.getIcon("leaf.png"));
            }
        }, treeCellEditor);
        this.filterLabelTree.setCellEditor(e2);
        this.filterLabelTree.setPopupMenu(this.popupFilterMenu);
    }

    private void switchLabelMode(String mode) {
        if ("editor".equals(mode)) {
            this.filterLabelTree.setEditable(true);
            this.filterLabelTree.offNodeSelectionListener();
            this.filterLabelTree.setCellRenderer(new ModeEditorTreeCellRenderer());
            this.filterLabelTree.setPopupMenu(this.popupEditorMenu);
        } else {
            this.filterLabelTree.setEditable(false);
            this.filterLabelTree.onNodeSelectionListener();
            this.filterLabelTree.setCellRenderer(new TariffLabelTreeCellRenderer());
            this.filterLabelTree.setPopupMenu(this.popupFilterMenu);
        }
    }

    class TreeDragSource
    implements DragSourceListener,
    DragGestureListener {
        DragSource source;
        DragGestureRecognizer recognizer;
        TransferableTariffLabelItem transferable;
        DefaultMutableTreeNode oldNode;
        JTree sourceTree;

        public TreeDragSource(JTree tree, int actions) {
            this.sourceTree = tree;
            this.source = new DragSource();
            this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            TreePath path = this.sourceTree.getSelectionPath();
            if (path != null && path.getPathCount() > 1) {
                this.oldNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (this.oldNode.isLeaf() && this.sourceTree.isEditable()) {
                    this.transferable = new TransferableTariffLabelItem(this.oldNode.getUserObject());
                    event.startDrag(DragSource.DefaultMoveDrop, this.transferable, this);
                }
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess() && event.getDropAction() == 2) {
                ((DefaultTreeModel)this.sourceTree.getModel()).removeNodeFromParent(this.oldNode);
            }
        }
    }

    class TreeDropTarget
    implements DropTargetListener {
        DropTarget target;
        JTree targetTree;

        public TreeDropTarget(JTree tree) {
            this.targetTree = tree;
            this.target = new DropTarget(this.targetTree, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            event.acceptDrag(event.getDropAction());
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            Point point = event.getLocation();
            JTree tree = (JTree)event.getDropTargetContext().getComponent();
            TreePath parentPath = tree.getClosestPathForLocation(point.x, point.y);
            if (parentPath != null) {
                try {
                    Transferable transferable = event.getTransferable();
                    DataFlavor[] flavors = transferable.getTransferDataFlavors();
                    for (int i = 0; i < flavors.length; ++i) {
                        if (!transferable.isDataFlavorSupported(flavors[i])) continue;
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
                        TariffLabelItem parentTariffLabelItem = (TariffLabelItem)parent.getUserObject();
                        TariffLabelItem tariffLabelItem = (TariffLabelItem)transferable.getTransferData(flavors[i]);
                        if (parentTariffLabelItem.getId() == tariffLabelItem.getId()) break;
                        tariffLabelItem.setParentId(parentTariffLabelItem.getId());
                        event.acceptDrop(event.getDropAction());
                        DefaultMutableTreeNode newTariffLabelTreeNode = new DefaultMutableTreeNode();
                        newTariffLabelTreeNode.setUserObject(tariffLabelItem);
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
                        defaultTreeModel.insertNodeInto(newTariffLabelTreeNode, parent, parent.getChildCount());
                        TariffLabelPanel.this.tryCall(() -> TariffLabelPanel.this.tariffService.get().updateTariffLabelTreeItem(tariffLabelItem));
                        tree.expandPath(new TreePath(parent.getPath()));
                        tree.scrollPathToVisible(new TreePath(parent.getPath()));
                        event.dropComplete(true);
                        return;
                    }
                    event.rejectDrop();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                    event.rejectDrop();
                }
            } else {
                event.rejectDrop();
            }
        }
    }

    class ModeButton
    extends JToggleButton {
        ModeButton(String actionCommand, ButtonGroup buttonGroup, ActionListener actionListener, String toolTipText) {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(20, 16));
            this.setToolTipText(toolTipText);
            buttonGroup.add(this);
            this.addActionListener(actionListener);
            this.setActionCommand(actionCommand);
            this.setText(String.valueOf(toolTipText.charAt(0)));
        }
    }

    class ModeEditorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public ModeEditorTreeCellRenderer() {
            this.setOpenIcon(ClientUtils.getIcon("node.png"));
            this.setClosedIcon(ClientUtils.getIcon("node.png"));
            this.setLeafIcon(ClientUtils.getIcon("leaf.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode tariffLabelTreeNode;
            Object userObject;
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (component instanceof JLabel && (userObject = (tariffLabelTreeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof TariffLabelItem) {
                TariffLabelItem tariffLabelItem = (TariffLabelItem)userObject;
                ((JLabel)component).setText(tariffLabelItem.getTitle() + " [#" + tariffLabelItem.getId() + "]");
            }
            return component;
        }
    }

    class TransferableTariffLabelItem
    implements Transferable {
        DataFlavor TARIFF_LABEL_ITEM_FLAVOR = new DataFlavor(TariffLabelItem.class, "TariffLabelItem");
        DataFlavor[] flavors = new DataFlavor[]{this.TARIFF_LABEL_ITEM_FLAVOR};
        Object object;

        public TransferableTariffLabelItem(Object object) {
            this.object = object;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.getRepresentationClass() == TariffLabelItem.class;
        }

        @Override
        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

