/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class BGTimePanel
extends JPanel {
    private static final String ENTER = "ENTER";
    private static final String CLEAR = "CLEAR";
    private LocalTime newTime = null;
    private JTabbedPane tabbedPane = null;
    private TimeField timeField = new TimeField();

    public BGTimePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.updateTime();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTimePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.getButtonsPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private JPanel getTimePanel() {
        AbstractAction okAction = new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String time = BGTimePanel.this.timeField.getText();
                if (time != null) {
                    BGTimePanel.this.newTime = LocalTime.from(DateTimeFormatter.ofPattern("HH:mm:ss").parse(time));
                    BGTimePanel.this.updateTime();
                    BGTimePanel.this.firePropertyChange("updateTime", true, false);
                }
            }
        };
        AbstractAction clearAction = new AbstractAction(" X "){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGTimePanel.this.newTime = null;
                BGTimePanel.this.firePropertyChange("updateTime", true, false);
            }
        };
        NavButton ok = new NavButton(okAction);
        ok.getActionMap().put(ENTER, okAction);
        ok.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ENTER);
        NavButton clear = new NavButton(clearAction);
        clear.getActionMap().put(CLEAR, okAction);
        clear.getInputMap().put(KeyStroke.getKeyStroke(27, 0), CLEAR);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.timeField, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)ok, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)clear, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonsPanel() {
        ActionListener actionListener = actionEvent -> this.buttonClick(actionEvent);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.getMinutePanel(actionListener), "\u041c\u0438\u043d\u0443\u0442\u044b");
        this.tabbedPane.add((Component)this.getSecondPanel(actionListener), "\u0421\u0435\u043a\u0443\u043d\u0434\u044b");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0427\u0430\u0441\u044b"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(7, 0, 0, 0), 0, 0));
        panel.add((Component)this.getHourPanel(actionListener), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tabbedPane, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHourPanel(ActionListener actionListener) {
        JPanel panel = new JPanel(new GridLayout(6, 4));
        for (int index = 0; index < 24; ++index) {
            panel.add(new TimeButton("h", (index < 10 ? "0" : "") + String.valueOf(index), actionListener));
        }
        return panel;
    }

    private JPanel getMinutePanel(ActionListener actionListener) {
        JPanel panel = new JPanel(new GridLayout(6, 10));
        for (int index = 0; index < 60; ++index) {
            panel.add(new TimeButton("m", (index < 10 ? "0" : "") + String.valueOf(index), actionListener));
        }
        return panel;
    }

    private JPanel getSecondPanel(ActionListener actionListener) {
        JPanel panel = new JPanel(new GridLayout(6, 10));
        for (int index = 0; index < 60; ++index) {
            panel.add(new TimeButton("s", (index < 10 ? "0" : "") + String.valueOf(index), actionListener));
        }
        return panel;
    }

    public LocalTime getTime() {
        return this.newTime;
    }

    public void setTime(LocalTime localTime) {
        this.newTime = localTime;
        this.updateTime();
    }

    public BGMaskTextField getTimeField() {
        return this.timeField;
    }

    private void buttonClick(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.startsWith("h")) {
            this.newTime = this.newTime.withHour(Utils.parseInt(actionCommand.substring(1), 0));
        } else if (actionCommand.startsWith("m")) {
            this.newTime = this.newTime.withMinute(Utils.parseInt(actionCommand.substring(1), 0));
        } else if (actionCommand.startsWith("s")) {
            this.newTime = this.newTime.withSecond(Utils.parseInt(actionCommand.substring(1), 0));
        }
        this.updateTime();
    }

    private void updateTime() {
        if (this.newTime == null) {
            return;
        }
        this.timeField.setText(this.newTime.format(DateTimeFormatter.ofPattern("HH:mm:ss")));
    }

    private class TimeField
    extends BGMaskTextField {
        TimeField() {
            super("  :  :  ", ":", new BGMaskTextField.IntegerValidator(0L, 23L, 2), new BGMaskTextField.IntegerValidator(0L, 59L, 2), new BGMaskTextField.IntegerValidator(0L, 59L, 2));
            this.setHorizontalAlignment(0);
        }
    }

    class NavButton
    extends JButton {
        private Font fontBold = new Font("Dialog", 1, 12);

        public NavButton(Action action) {
            this.setMargin(new Insets(2, 2, 2, 2));
            this.setFont(this.fontBold);
            this.setAction(action);
        }
    }

    class TimeButton
    extends JButton {
        private Font fontPlain;
        private Insets insets;
        private Dimension dimension;

        TimeButton(String prefix, String text, ActionListener actionListener) {
            super(text);
            this.fontPlain = new Font("Dialog", 0, 10);
            this.insets = new Insets(0, 0, 0, 0);
            this.dimension = new Dimension(26, 20);
            this.setFont(this.fontPlain);
            this.setMargin(this.insets);
            this.setMinimumSize(this.dimension);
            this.setPreferredSize(this.dimension);
            this.setActionCommand(prefix + text);
            this.addActionListener(actionListener);
        }
    }
}

