/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Charge
extends BGJasperReport {
    public Report_Charge() {
        this.id = "kernel_contract_charge";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws BGException {
        try {
            BGReportFilter filter = this.createBGReportFilter();
            java.sql.Date date1 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy"));
            java.sql.Date date2 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy"));
            String types = filter.getStringParam("pt");
            String groups = filter.getStringParam("gr");
            String sortColumn = filter.getStringParam("sortCol");
            String mask = filter.getStringParam("mask");
            String groupMode = filter.getStringParam("group_mode");
            if (types != null && groups != null && sortColumn != null) {
                long groupMask = Utils.enumToMask((String)groups);
                Object query = "SELECT t1.title AS c1, t1.comment AS c2, t2.summa AS c3, t2.dt AS c4, t3.title AS c5, t2.comment AS c6 FROM  contract AS t1, contract_charge AS t2, contract_charge_types AS t3  WHERE t1.id=t2.cid AND t3.id=t2.pt AND ( t2.dt >= ? OR ISNULL( ? ) )   AND ( t2.dt <= ? OR ISNULL( ? ) ) ";
                if (groupMask != 0L && Utils.notEmptyString((String)groupMode)) {
                    query = groupMode.equals("or") ? (String)query + " AND t1.gr & " + groupMask + " > 0 " : (String)query + " AND t1.gr & " + groupMask + "=" + groupMask + " ";
                }
                if (types != null && types.length() > 0) {
                    query = (String)query + "AND t2.pt IN ( " + types + " ) ";
                }
                if (Utils.notEmptyString((String)mask)) {
                    query = (String)query + "AND t1.title REGEXP '" + mask + "' ";
                }
                query = (String)query + "ORDER BY " + sortColumn;
                PreparedStatement ps = this.con.prepareStatement((String)query);
                ps.setDate(1, date1);
                ps.setDate(2, date1);
                ps.setDate(3, date2);
                ps.setDate(4, date2);
                ResultSet rs = ps.executeQuery();
                BGDataSource data = new BGDataSource();
                BigDecimal sum = BigDecimal.ZERO;
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("col1", rs.getString(1));
                    row.put("col2", rs.getString(2));
                    String summa = rs.getString(3);
                    sum = sum.add(new BigDecimal(summa));
                    row.put("col3", String.valueOf(summa));
                    row.put("col4", TimeUtils.format((Date)rs.getDate(4), (String)"dd.MM.yyyy"));
                    row.put("col5", rs.getString(5));
                    row.put("col6", rs.getString(6));
                    data.addRow(row);
                }
                rs.close();
                ps.close();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("sum", sum.toPlainString());
                this.fillReportToStream(this.id, out, params, data);
            }
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)ex);
        }
    }
}

