/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.monitoring.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.MonitoringComponent;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.MonitoringComponentLogging;
import ru.bitel.bgbilling.plugins.monitoring.common.service.MonitoringService;
import ru.bitel.common.client.table.BGTableModel;

public class MonitoringLoggingPanel
extends BGUPanel {
    private MonitoringComponent monitoringComponent;
    private LoggingTableModel model = new LoggingTableModel();

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    public void setMonitoringComponent(MonitoringComponent monitoringComponent) {
        this.monitoringComponent = monitoringComponent;
        this.refresh();
    }

    public void refresh() {
        try {
            this.model.setData(((MonitoringService)((ClientContext)this.getContext()).getWebService(MonitoringService.class)).componentLoggingList(this.monitoringComponent.getObjectName()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class LoggingTableModel
    extends BGTableModel<MonitoringComponentLogging> {
        public LoggingTableModel() {
            super(LoggingTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("Logger", 100, 200, -1, "loggerName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("ERROR", 100, 200, 100, "error", true);
            this.addColumn("INFO", 100, 200, 100, "info", true);
            this.addColumn("DEBUG", 100, 200, 100, "debug", true);
        }

        public Object getValue(MonitoringComponentLogging val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "error": 
                case "info": 
                case "debug": {
                    return val.getLoggerLevel().equals(identifier);
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

