/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;

public class MegogoContractSubscriptionDao
extends AbstractIdDao<MegogoContractSubscription> {
    public MegogoContractSubscriptionDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_subscription");
    }

    public List<MegogoContractSubscription> getContractSubscriptionList(int contractId, int serviceId, Date date) throws SQLException {
        String servStr = serviceId < 1 ? null : "" + serviceId;
        return this.getContractsSubscriptionList("" + contractId, servStr, -1, date, date, -1);
    }

    public List<MegogoContractSubscription> getContractSubscriptionList(int contractId, int serviceId, int type, Period period, int exceptContractSubId) throws SQLException {
        String servStr = serviceId < 1 ? null : "" + serviceId;
        return this.getContractsSubscriptionList("" + contractId, servStr, type, period == null ? null : period.getDateFrom(), period == null ? null : period.getDateTo(), exceptContractSubId);
    }

    public List<MegogoContractSubscription> getContractsSubscriptionList(String contracts, String serviceIds, int type, Date dateFrom, Date dateTo, int exceptContractSubId) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT mcs.* FROM " + this.tableName + " AS mcs");
        if (type > 0) {
            query.append(" LEFT JOIN megogo_subscription_" + this.moduleId + " AS ms ON ms.sid=mcs.sid");
        }
        query.append(" WHERE 1=1 ");
        if (Utils.notBlankString((String)serviceIds)) {
            query.append(" AND mcs.sid IN(" + serviceIds + ")");
        }
        if (Utils.notBlankString((String)contracts)) {
            query.append(" AND mcs.contractId IN(" + contracts + ")");
        }
        if (dateTo != null) {
            query.append(" AND mcs.dateFrom<=? ");
        }
        if (dateFrom != null) {
            query.append(" AND ( mcs.dateTo IS NULL OR mcs.dateTo>=? )");
        }
        if (type > 0) {
            query.append(" AND ms.type=" + type);
        }
        if (exceptContractSubId > 0) {
            query.append(" AND mcs.id!=" + exceptContractSubId);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            List list;
            block21: {
                int index = 1;
                if (dateTo != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateTo));
                }
                if (dateFrom != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block21;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    protected MegogoContractSubscription getFromRS(ResultSet rs) throws SQLException {
        MegogoContractSubscription service = new MegogoContractSubscription();
        service.setId(rs.getInt("id"));
        service.setContractId(rs.getInt("contractId"));
        service.setServiceId(rs.getInt("sid"));
        service.setStatus(rs.getInt("status"));
        service.setSubscriptionFrom(rs.getInt("subscriptionIdFrom"));
        service.setCount(rs.getInt("count"));
        service.setComment(rs.getString("comment"));
        service.setPeriod(new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo")));
        service.setDateActivated(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activated_time")));
        service.setDateDeactivated(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("deactivated_time")));
        service.setLm((Date)rs.getTimestamp("lm"));
        service.setUserId(rs.getInt("userId"));
        return service;
    }

    protected void updateImpl(MegogoContractSubscription contractSubscription) throws SQLException {
        boolean update = contractSubscription.getId() > 0;
        String querySet = "contractId=?, sid=?, subscriptionIdFrom=?, status=?, count=?, dateFrom=?, dateTo=?, comment=?, userId=?" + (!update && contractSubscription.getDateActivated() != null && contractSubscription.getStatus() == 0 ? ", activated_time=?" : "");
        try (PreparedStatement ps = this.prepareStatement((Id)contractSubscription, querySet);){
            int index = 1;
            ps.setInt(index++, contractSubscription.getContractId());
            ps.setInt(index++, contractSubscription.getServiceId());
            ps.setInt(index++, contractSubscription.getSubscriptionFrom());
            ps.setInt(index++, contractSubscription.getStatus());
            ps.setInt(index++, contractSubscription.getCount());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractSubscription.getPeriod().getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractSubscription.getPeriod().getDateTo()));
            ps.setString(index++, contractSubscription.getComment());
            ps.setInt(index++, contractSubscription.getUserId());
            if (!update && contractSubscription.getDateActivated() != null && contractSubscription.getStatus() == 0) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractSubscription.getDateActivated()));
            }
            this.executeUpdate((Id)contractSubscription, index, ps);
        }
    }

    public MegogoContractSubscription getByFromId(int idFrom) throws SQLException {
        String query = "SELECT * FROM " + this.tableName + " WHERE subscriptionIdFrom=" + idFrom;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            MegogoContractSubscription megogoContractSubscription;
            block12: {
                ResultSet rs = ps.executeQuery();
                try {
                    MegogoContractSubscription megogoContractSubscription2 = megogoContractSubscription = rs.next() ? this.getFromRS(rs) : null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return megogoContractSubscription;
        }
    }

    public int updateDateActivated(int id, Date date) throws SQLException {
        return this.updateDate(id, date, "activated_time");
    }

    public int updateDateDeactivated(int id, Date date) throws SQLException {
        return this.updateDate(id, date, "deactivated_time");
    }

    private int updateDate(int id, Date date, String field) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET " + field + "=? WHERE id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)date));
            int n = ps.executeUpdate();
            return n;
        }
    }

    public List<MegogoContractSubscription> getSubscriptionsForClose(Date date, boolean inclusive) throws SQLException {
        if (date == null) {
            return null;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE status!= 2 AND dateTo IS NOT NULL AND dateTo" + (inclusive ? "<=" : "<") + "?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
            List list = this.getListFromRS(ps.executeQuery());
            return list;
        }
    }

    public List<MegogoContractSubscription> getSubscriptionsForOpen(Date date, boolean inclusive) throws SQLException {
        if (date == null) {
            return null;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE status= 3 AND ( dateTo IS NULL OR dateTo>? ) AND dateFrom" + (inclusive ? "<=" : "<") + "?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            List list = this.getListFromRS(ps.executeQuery());
            return list;
        }
    }
}

