/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.Server;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.bootstrap.Shutdown;

public class AdminPortListener
extends BGLogger
implements Runnable {
    private Setup setup;
    private DatagramSocket socket;

    public AdminPortListener(Setup setup, int port) {
        this.setup = setup;
        if (port <= 0) {
            port = Utils.parseInt((String)System.getProperty("ru.bitel.common.bootstrap.adminPort"), (int)0);
        }
        if (port <= 0 && setup != null) {
            port = setup.getInt("port.admin", 2005);
        }
        this.getLogger().info("Starting listen admin port {}", (Object)port);
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (Exception ex) {
            this.getLogger().error("Port {} is busy! [{}]", (Object)port, (Object)ex.toString());
            System.exit(1);
        }
        try {
            Class.forName("bitel.billing.common.VersionInfo");
            Class.forName("ru.bitel.bgbilling.kernel.application.server.Application");
            Class.forName("bitel.billing.server.Server");
            Class.forName("ru.bitel.common.TimeUtils");
            Class.forName(OnStopShutdown.class.getName());
        }
        catch (ClassNotFoundException ex) {
            this.getLogger().error("Error classpath? not found class: {}", (Object)ex.toString());
            System.exit(2);
        }
        this.start();
    }

    public void setSetupData(Setup setup) {
        this.setup = setup;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[100];
        byte[] data = null;
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    data = packet.getData();
                    String command = new String(data, 0, packet.getLength(), "ISO-8859-1").trim();
                    this.getLogger().info("Admin command: " + command);
                    if (command.equals("stop")) {
                        try {
                            Shutdown.addOnShutdown((Shutdown.OnShutdown)new OnStopShutdown(this, packet));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        System.exit(0);
                        continue;
                    }
                    if (command.equals("status")) {
                        this.sendResponse(this.getStatus(), packet);
                        continue;
                    }
                    if (command.equals("conpool")) {
                        this.sendResponse(this.setup.getPoolStackTrace(), packet);
                        continue;
                    }
                    String result = Application.executeCommonCommand(command);
                    if (result != null) {
                        this.sendResponse(result, packet);
                        continue;
                    }
                    this.sendResponse("Unknown admin command: " + command, packet);
                }
            }
            catch (Exception ex) {
                this.getLogger().error("AdminPortListener error", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private void sendResponse(String responseStr, DatagramPacket inPacket) throws Exception {
        int MAX_SIZE = 65533;
        if (responseStr.length() > MAX_SIZE) {
            responseStr = responseStr.substring(0, MAX_SIZE);
        }
        byte[] responseBytes = responseStr.getBytes("ISO-8859-1");
        DatagramPacket response = new DatagramPacket(responseBytes, responseBytes.length, inPacket.getAddress(), inPacket.getPort());
        this.socket.send(response);
    }

    private String getStatus() {
        StringBuffer status = new StringBuffer();
        VersionInfo vi = VersionInfo.getVersionInfo((String)"kernel");
        status.append("BGBillingServer v ");
        status.append(vi.getVersionString());
        status.append("\n");
        status.append(ServerUtils.uptimeStatus(Server.START_TIME));
        status.append("\n");
        status.append(Utils.memoryStatus());
        if (this.setup != null) {
            status.append("\n");
            status.append(this.setup.getPoolStatus());
        }
        return status.toString();
    }

    public void start() {
        new Thread((Runnable)this, "AdminPortListener").start();
    }

    private static class OnStopShutdown
    implements Shutdown.OnShutdown {
        private AdminPortListener adminPortListener;
        private DatagramPacket packet;

        public OnStopShutdown(AdminPortListener adminPortListener, DatagramPacket packet) {
            this.adminPortListener = adminPortListener;
            this.packet = packet;
        }

        public void onShutdown() {
            try {
                this.adminPortListener.sendResponse("OK stopping", this.packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

