/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tariff;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class ServiceCostTariffTreeNode
extends DefaultTariffTreeNode {
    private BigDecimal cost;

    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map data = this.getDataInHash();
        String cost = (String)data.get("cost");
        if (cost != null) {
            this.cost = Utils.parseBigDecimal((String)cost, null);
        }
    }

    public void processRequest(TariffRequest request) {
        if (this.cost != null) {
            Calendar time = (Calendar)request.getRequestParam("time");
            int dayCount = time.getActualMaximum(5);
            BigDecimal dayCost = this.cost.divide(new BigDecimal(dayCount), 5, RoundingMode.UP);
            request.setResponseParam("cost", (Object)dayCost);
            request.setAccepted();
        }
    }
}

