/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paymaster.common.service.PayMasterService;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.paymaster.server.event.PaymasterAutopaymentEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.paymaster.common.service.PayMasterService")
public class PayMasterServiceImpl
extends AbstractService
implements PayMasterService {
    private TransactionManager manager;
    @Resource
    private ContractAutopaymentService contractAutopaymentService;

    @PostConstruct
    protected void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(int paymasterId, int contractId, String status, PeriodWithTime period, Page page) throws Exception {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setPeriod(period);
        this.manager.searchTransactionList((SearchResult<Transaction>)searchResult, paymasterId, contractId, status);
        return searchResult;
    }

    public void beginTransaction(int contractId, BigDecimal sum, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws Exception {
        if (mode != null) {
            mode.value = "redirect";
        }
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            String email;
            String paymentMethod;
            String createToken;
            String failureUrl;
            Contract contract = (Contract)contractDao.get(contractId);
            String contractTitle = contract.getTitle();
            ModuleSetup moduleSetup = this.getModuleSetup();
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setPaymentId(-1)).setStatus(TransactionStatus.NOPAY.getCode())).setCreateDate(new Date())).setAutopayment(false)).setSum(sum)).build();
            new TransactionManager(this.getConnection(), this.moduleId).update(transaction);
            StringBuilder redirectUrl = new StringBuilder();
            redirectUrl.append(moduleSetup.get("paymaster.gate.url", "https://paymaster.ru/Payment/Init"));
            redirectUrl.append("?");
            this.addRequestParamPair(redirectUrl, "LMI_MERCHANT_ID", moduleSetup.get("paymaster.merchant.id", ""));
            this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_AMOUNT", sum.toPlainString());
            this.addRequestParamPair(redirectUrl, "LMI_CURRENCY", moduleSetup.get("paymaster.currecy", "RUB"));
            this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_NO", String.valueOf(transaction.getId()));
            String desc = moduleSetup.get("paymaster.payment.desc", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}");
            this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_DESC", desc.replace("{CONTRACT_TITLE}", contractTitle));
            desc = moduleSetup.get("paymaster.payment.desc.base64", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}");
            this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_DESC_BASE64", desc == null ? null : Base64.encode((String)desc.replace("{CONTRACT_TITLE}", contractTitle), (String)"UTF-8"));
            this.addRequestParamPair(redirectUrl, "LMI_SIM_MODE", moduleSetup.get("paymaster.sim.mode", "0"));
            this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_NOTIFICATION_URL", moduleSetup.get("paymaster.payment.notification.url", ""));
            this.addRequestParamPair(redirectUrl, "LMI_INVOICE_CONFIRMATION_URL", moduleSetup.get("LMI_INVOICE_CONFIRMATION_URL", ""));
            Map params = paramsHolder != null && paramsHolder.value != null ? ((MapHolder)paramsHolder.value).getMap() : null;
            String successUrl = params != null ? (String)params.get("successUrl") : null;
            String string = failureUrl = params != null ? (String)params.get("failureUrl") : null;
            if (Utils.isBlankString((String)successUrl)) {
                successUrl = moduleSetup.get("paymaster.success.url", "");
            }
            if (Utils.isBlankString((String)failureUrl)) {
                failureUrl = moduleSetup.get("paymaster.failure.url", "");
            }
            if (params != null && params.containsKey("LMI_CREATE_TOKEN") && (createToken = (String)params.get("LMI_CREATE_TOKEN")) != null && "True".equals(createToken)) {
                this.addRequestParamPair(redirectUrl, "LMI_CREATE_TOKEN", createToken);
            }
            if (params != null && params.containsKey("LMI_PAYMENT_METHOD") && (paymentMethod = (String)params.get("LMI_PAYMENT_METHOD")) != null) {
                this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_METHOD", paymentMethod);
            }
            this.addRequestParamPair(redirectUrl, "LMI_SUCCESS_URL", successUrl);
            this.addRequestParamPair(redirectUrl, "LMI_FAILURE_URL", failureUrl);
            String phone = params != null ? (String)params.get("phone") : null;
            String string2 = email = params != null ? (String)params.get("email") : null;
            if (phone != null) {
                phone = phone.replaceAll("[+\\(\\)\\-\\s]", "");
            }
            this.addRequestParamPair(redirectUrl, "LMI_PAYER_PHONE_NUMBER", Utils.maskNull((String)phone));
            this.addRequestParamPair(redirectUrl, "LMI_PAYER_EMAIL", Utils.maskNull((String)email));
            if (moduleSetup.getBoolean("paymaster.fiscalization.enable", false)) {
                this.addRequestParamPair(redirectUrl, "LMI_SHOPPINGCART.ITEMS[0].NAME", moduleSetup.get("paymaster.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
                this.addRequestParamPair(redirectUrl, "LMI_SHOPPINGCART.ITEMS[0].QTY", String.valueOf(moduleSetup.getInt("paymaster.fiscalization.receipt.qty", 1)));
                this.addRequestParamPair(redirectUrl, "LMI_SHOPPINGCART.ITEMS[0].PRICE", sum.toPlainString());
                this.addRequestParamPair(redirectUrl, "LMI_SHOPPINGCART.ITEMS[0].TAX", moduleSetup.get("paymaster.fiscalization.receipt.tax", "vat0"));
            }
            url.value = redirectUrl.toString();
            if (paramsHolder != null) {
                paramsHolder.value = null;
            }
        }
    }

    private void addRequestParamPair(StringBuilder request, String name, String value) throws Exception {
        if (value != null) {
            request.append(URLEncoder.encode(name, "UTF-8"));
            request.append("=");
            request.append(URLEncoder.encode(value, "UTF-8"));
            request.append("&");
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws Exception {
        return new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId);
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws Exception {
        AutopaymentManager autopaymentManager;
        Autopayment autopayment;
        if (contractId > 0 && (autopayment = (autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId)).getCurrentAutopayment(contractId)) != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
            EventProcessor.getInstance().publish((Event)new PaymasterAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
        }
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> m, Holder<MapHolder<String, String>> params, ContractAutopaymentMode mode) throws Exception {
        Autopayment autopayment;
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (amount == null) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if ((amount = amount.setScale(2, RoundingMode.HALF_EVEN)).compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.", "contractModule.notEnabled");
        }
        Connection con = this.getConnection();
        ModuleSetup moduleSetup = this.getModuleSetup();
        boolean autopaymentEnable = moduleSetup.getBoolean("paymaster.autopayment.enable", false);
        boolean createToken = false;
        if (mode != null && mode.getMode() != AutopaymentMode.OFF) {
            this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, mode);
        }
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)con, (int)this.moduleId, (int)contractId) && (autopayment = AutopaymentManager.registerAutopayment((Connection)this.getConnection(), (int)this.moduleId, (AbstractAutopaymentManager)new AutopaymentManager(this.getConnection(), this.moduleId), (int)contractId, (ContractAutopaymentMode)mode, null)) != null && autopayment.getMode() != AutopaymentMode.OFF) {
            createToken = true;
        }
        if (createToken) {
            ((MapHolder)params.value).getMap().put("LMI_CREATE_TOKEN", "True");
            ((MapHolder)params.value).getMap().put("LMI_PAYMENT_METHOD", moduleSetup.get("paymaster.payment.method", "503"));
            this.beginTransaction(contractId, amount, url, m, params);
        }
    }
}

