/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobilePushToken;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class MobilePushTokenDao
extends AbstractIdDao<MobilePushToken> {
    public MobilePushTokenDao(Connection con, int moduleId) {
        super(con, moduleId, "mobile_push_tokens");
    }

    protected MobilePushToken getFromRS(ResultSet rs) throws SQLException {
        MobilePushToken token = new MobilePushToken();
        token.setId(rs.getInt("id"));
        token.setToken(rs.getString("token"));
        token.setType(rs.getInt("type"));
        token.setDateCreate(rs.getTimestamp("dateCreate"));
        token.setLastSendDate(rs.getTimestamp("lastSendDate"));
        token.setLastConfirmDate(rs.getTimestamp("lastConfirmDate"));
        token.setRejected(rs.getInt("rejected"));
        token.setRejectedDate(rs.getTimestamp("rejectedDate"));
        return token;
    }

    protected void updateImpl(MobilePushToken token) throws SQLException {
        Objects.requireNonNull(token);
        boolean update = token.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + (update ? " SET lastSendDate=?, lastConfirmDate=?, rejected=?, rejectedDate=?" : " SET token=?, type=?, dateCreate=NOW(), lastConfirmDate=NOW()") + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 0;
            if (update) {
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)token.getLastSendDate()));
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)token.getLastConfirmDate()));
                ps.setInt(++index, token.getRejected());
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)token.getRejectedDate()));
                ps.setInt(++index, token.getId());
            } else {
                ps.setString(++index, token.getToken());
                ps.setInt(++index, token.getType());
            }
            ps.executeUpdate();
            if (!update) {
                token.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public MobilePushToken getByToken(String token, int type) throws SQLException {
        if (2 == type || 1 == type) {
            return (MobilePushToken)((Object)this.get("token=? AND type=?", new Object[]{token, type}));
        }
        return (MobilePushToken)((Object)this.get("token=?", new Object[]{token}));
    }
}

