/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.client;

import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ServiceConfigManagerRevise
extends ServiceConfigTabbedPanel {
    private BGSelectFilePanel selectFilePanel = new BGSelectFilePanel(false);
    private BGButton process = new BGButton();
    private JTabbedPane tabbed = new JTabbedPane();
    private BGTable exTable = new BGTable();
    private BGTable dbTable = new BGTable();
    private BGTable disTable = new BGTable();
    private JList<BGUListItem> dealerList = new JList();
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();

    public ServiceConfigManagerRevise() {
        this.initialize();
        this.exTable.setHeader(this.rb_name, this.moduleDoc, "payments_revise");
        this.dbTable.setHeader(this.rb_name, this.moduleDoc, "payments_revise");
        this.disTable.setHeader(this.rb_name, this.moduleDoc, "payments_revise");
    }

    private void initialize() {
        JSplitPane jSplitPane1 = new JSplitPane();
        jSplitPane1.setBorder(null);
        jSplitPane1.setDividerSize(5);
        this.tabbed.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 "));
        this.setLayout(new GridBagLayout());
        JPanel toppanel = new JPanel(new GridBagLayout());
        toppanel.setBorder((Border)new BGTitleBorder(" \u0424\u0430\u0439\u043b "));
        toppanel.add((Component)this.selectFilePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.process.setText("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c");
        this.process.setActionCommand("process");
        toppanel.add((Component)this.process, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel pan = new JPanel(new GridBagLayout());
        pan.setBorder((Border)new BGTitleBorder(" \u0414\u0438\u043b\u0435\u0440\u044b "));
        pan.add((Component)new JScrollPane(this.dealerList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 5, 5), 0, 0));
        jSplitPane1.add((Component)pan, "left");
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        rightPanel.add((Component)toppanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 0), 0, 0));
        BGPanel tab1 = new BGPanel((LayoutManager)new GridBagLayout());
        tab1.add((Component)new JScrollPane((Component)this.exTable), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGPanel tab2 = new BGPanel((LayoutManager)new GridBagLayout());
        tab2.add((Component)new JScrollPane((Component)this.dbTable), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGPanel tab3 = new BGPanel((LayoutManager)new GridBagLayout());
        tab3.add((Component)new JScrollPane((Component)this.disTable), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tabbed.addTab("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", (Component)tab2);
        this.tabbed.addTab("\u041b\u0438\u0448\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", (Component)tab1);
        this.tabbed.addTab("\u041e\u0442\u043b\u0438\u0447\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0438", (Component)tab3);
        rightPanel.add((Component)this.tabbed, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        jSplitPane1.add((Component)rightPanel, "right");
        this.add(jSplitPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.process.addActionListener(e -> this.actionMapper(e));
        jSplitPane1.setDividerLocation(270);
    }

    private void actionMapper(String action) {
        if (action.equals("process")) {
            this.processFile();
        }
    }

    private void actionMapper(ActionEvent e) {
        this.actionMapper(e.getActionCommand());
    }

    private void processFile() {
        File file = this.selectFilePanel.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        BGUListItem item = this.dealerList.getSelectedValue();
        if (item == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u043b\u0435\u0440\u0430!");
            return;
        }
        String fileString = null;
        try {
            fileString = new String(Utils.readByBlock((InputStream)new FileInputStream(file)), "UTF-8");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("DealerRevise");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", (String)item.getAttribute("id"));
        request.setAttribute("file", fileString);
        request.setAttribute("from", this.periodPanel.getDateString1());
        request.setAttribute("until", this.periodPanel.getDateString2());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.dbTable.updateData(XMLUtils.getNode((Document)doc, (String)"mis_table"));
            this.exTable.updateData(XMLUtils.getNode((Document)doc, (String)"sup_table"));
            this.disTable.updateData(XMLUtils.getNode((Document)doc, (String)"dis_table"));
        }
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAttribute("type", 2);
        request.setAction("ListDealers");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList(this.dealerList, (Node)XMLUtils.getNode((Document)doc, (String)"dealers"));
        }
    }
}

