/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.hierarchy.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class HierarchyPanel
extends BGPanel {
    private static final Font font = new Font("Arial", 1, 16);
    private int superId;
    private JLabel superLabel = new JLabel();
    private JLabel labelDepend = new JLabel();
    private CardLayout cardLayout = new CardLayout();
    private BGControlPanelContractSelect contractSelectFreeMode = new BGControlPanelContractSelect(false);
    private BGControlPanelContractSelect contractSelectSuperMode = new BGControlPanelContractSelect(false);
    private BGUComboBox<KeyValue> subModeFreeMode = new BGUComboBox();
    private BGUComboBox<KeyValue> subModeSuperMode = new BGUComboBox();
    private JCheckBox onDateMode = new JCheckBox("\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u043d\u0430 \u0434\u0430\u0442\u0443", true);
    private BGControlPanelDateNoB onDate = new BGControlPanelDateNoB();
    private List<Status> statusList = new ArrayList<Status>();
    private SuperContractTableModel superContractTableModel = new SuperContractTableModel();

    public HierarchyPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(this.cardLayout);
        this.add((Component)this.getSubPanel(), "sub");
        this.add((Component)this.getFreePanel(), "free");
        this.add((Component)this.getSuperPanel(), "super");
    }

    private JPanel getSubPanel() {
        this.labelDepend.setHorizontalAlignment(0);
        this.labelDepend.setFont(font);
        this.superLabel.setHorizontalAlignment(0);
        this.superLabel.setFont(font);
        JButton openButton = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        openButton.addActionListener(e -> ClientUtils.openContract(this.superId));
        JButton freeButton = new JButton("\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        freeButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440?", "\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 0) == 0) {
                this.freeThis();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.labelDepend, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.superLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)openButton, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(15, 5, 0, 5), 0, 0));
        panel.add((Component)freeButton, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(15, 5, 0, 5), 0, 0));
        panel.add(Box.createVerticalStrut(2), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 3, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getFreePanel() {
        JLabel label = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c");
        label.setFont(font);
        JButton setSuperButton = new JButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        setSuperButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440?", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 0) == 0) {
                this.setSuper(this.subModeFreeMode);
            }
        });
        JButton addSubButton = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        addSubButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 0) == 0) {
                this.addSub(this.contractSelectFreeMode, this.subModeFreeMode);
            }
        });
        this.subModeFreeMode.setData(Arrays.asList(new KeyValue(String.valueOf(0), "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"), new KeyValue(String.valueOf(1), "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441")));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.contractSelectFreeMode, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(this.subModeFreeMode, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)setSuperButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)addSubButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(Box.createVerticalStrut(2), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getSuperPanel() {
        this.onDate.setLocalDate(LocalDate.now());
        this.onDate.addActionListener(a -> this.setData());
        this.onDateMode.addChangeListener(a -> this.setData());
        JLabel label = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u0434\u043b\u044f");
        label.setFont(font);
        BGUTable table = new BGUTable(this.superContractTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    HierarchyPanel.this.openSub();
                }
            }
        });
        JButton openSub = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        openSub.addActionListener(e -> this.openSub());
        JButton freeSub = new JButton("\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        freeSub.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 0) == 0) {
                this.freeSub();
            }
        });
        JButton addSub = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        addSub.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 0) == 0) {
                this.addSub(this.contractSelectSuperMode, this.subModeSuperMode);
            }
        });
        this.subModeSuperMode.setData(Arrays.asList(new KeyValue(String.valueOf(0), "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"), new KeyValue(String.valueOf(1), "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441")));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)label, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.onDateMode, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)this.onDate, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 45), 0, 0));
        topPanel.add((Component)openSub, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)freeSub, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)this.contractSelectSuperMode, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        bottomPanel.add(this.subModeSuperMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)addSub, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)bottomPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        try {
            this.statusList = this.getContext().getWebService(ContractStatusService.class).getStatusList(false);
            List<Contract> list = this.getContext().getPort(ContractService.class).contractSubList(this.getContractId(), -1, true, this.onDateMode.isSelected() ? this.onDate.getDate() : null);
            Contract contract = list.get(0);
            String status = "free";
            if (contract.isSuper()) {
                status = "super";
                ArrayList<SuperTableRow> items = new ArrayList<SuperTableRow>();
                for (Contract sub : list) {
                    if (sub == contract) continue;
                    items.add(SuperTableRow.fromContract(this.statusList, sub));
                }
                this.superContractTableModel.setData(items);
            } else if (contract.isSub()) {
                status = "sub";
                this.superId = contract.getSuperCid();
                Contract superContract = this.getContext().getPort(ContractService.class).contractGet(contract.getSuperCid());
                this.superLabel.setText((String)(superContract != null ? superContract.getTitle() + " [" + superContract.getComment() + "]" : ""));
                byte mode = contract.getBalanceSubMode();
                Object modeStr = "???";
                if (mode == 0 || mode == 1) {
                    modeStr = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u0441 " + (mode == 0 ? "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c" : "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c") + " \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u043c \u0434\u043b\u044f";
                }
                this.labelDepend.setText((String)modeStr);
            }
            this.cardLayout.show(this, status);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.contractSelectFreeMode.init(module, moduleId);
        this.contractSelectFreeMode.setIgnoredCid(this.getContractId());
        this.contractSelectSuperMode.init(module, moduleId);
        this.contractSelectSuperMode.setIgnoredCid(this.getContractId());
    }

    private void setSuper(BGUComboBox<KeyValue> subMode) {
        String superId = this.contractSelectFreeMode.getContracts();
        if (Utils.isBlankString(superId) || superId.indexOf(",") >= 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
            return;
        }
        Request request = new Request();
        request.setModule("contract.hierarchy");
        request.setAction("AddSub");
        request.setAttribute("super", superId);
        request.setAttribute("sub", this.getContractId());
        request.setAttribute("sub_mode", (String)Optional.ofNullable((KeyValue)subMode.getSelectedItem()).map(a -> a.getKey()).orElse(null));
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            this.setData();
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
    }

    private void addSub(BGControlPanelContractSelect contractSelect, BGUComboBox<KeyValue> subMode) {
        String subIdList = contractSelect.getContracts();
        if (Utils.isBlankString(subIdList)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b!");
            return;
        }
        boolean wasAdd = false;
        StringTokenizer st = new StringTokenizer(subIdList, ",");
        while (st.hasMoreTokens()) {
            Request req = new Request();
            req.setModule("contract.hierarchy");
            req.setAction("AddSub");
            req.setAttribute("super", this.getContractId());
            req.setAttribute("sub", st.nextToken().trim());
            req.setAttribute("sub_mode", (String)Optional.ofNullable((KeyValue)subMode.getSelectedItem()).map(a -> a.getKey()).orElse(null));
            if (!ClientUtils.checkStatus(this.getDocument(req))) continue;
            wasAdd = true;
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
        if (wasAdd) {
            this.setData();
        }
    }

    private void freeThis() {
        Request req = new Request();
        req.setModule("contract.hierarchy");
        req.setAction("FreeContract");
        req.setContractId(this.getContractId());
        if (ClientUtils.checkStatus(this.getDocument(req))) {
            this.setData();
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
    }

    private void freeSub() {
        int id;
        SuperTableRow li = (SuperTableRow)this.superContractTableModel.getSelectedRow();
        int n = id = li != null ? li.getContractId() : -1;
        if (id > 0) {
            Request req = new Request();
            req.setModule("contract.hierarchy");
            req.setAction("FreeContract");
            req.setContractId(id);
            if (ClientUtils.checkStatus(this.getDocument(req))) {
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
        }
    }

    private void openSub() {
        this.superContractTableModel.optSelectedRow().ifPresentOrElse(contract -> ClientUtils.openContract(contract.getContractId()), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440!"));
    }

    class SuperContractTableModel
    extends BGTableModel<SuperTableRow> {
        public SuperContractTableModel() {
            super(SuperContractTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "contractPeriod", true);
            this.addColumn("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 150, 200, 300, "contractTitle", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "contractComment", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 150, 200, "contractStatus", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0411\u0430\u043b\u0430\u043d\u0441", 100, 120, 150, "balanceSubMode", true, HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    public static class SuperTableRow {
        private int contractId;
        private String contractStatus;
        private Period contractPeriod;
        private String contractTitle;
        private String contractComment;
        private String balanceSubMode;

        public Period getContractPeriod() {
            return this.contractPeriod;
        }

        public void setContractPeriod(Period contractPeriod) {
            this.contractPeriod = contractPeriod;
        }

        public String getBalanceSubMode() {
            return this.balanceSubMode;
        }

        public void setBalanceSubMode(String balanceSubMode) {
            this.balanceSubMode = balanceSubMode;
        }

        public int getContractId() {
            return this.contractId;
        }

        public void setContractId(int contractId) {
            this.contractId = contractId;
        }

        public String getContractTitle() {
            return this.contractTitle;
        }

        public void setContractTitle(String contractTitle) {
            this.contractTitle = contractTitle;
        }

        public String getContractComment() {
            return this.contractComment;
        }

        public void setContractComment(String contractComment) {
            this.contractComment = contractComment;
        }

        public String getContractStatus() {
            return this.contractStatus;
        }

        public void setContractStatus(String contractStatus) {
            this.contractStatus = contractStatus;
        }

        public static SuperTableRow fromContract(List<Status> statusList, Contract contract) {
            SuperTableRow row = new SuperTableRow();
            row.setContractId(contract.getId());
            row.setContractTitle(contract.getTitle());
            row.setContractComment(contract.getComment());
            row.setBalanceSubMode(contract.getBalanceSubMode() == 0 ? "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439" : "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439");
            row.setContractPeriod(new Period(contract.getDateFrom(), contract.getDateTo()));
            row.setContractStatus(statusList.stream().filter(a -> a.getId() == contract.getStatus()).findFirst().map(a -> a.getTitle()).orElse("? [#" + contract.getStatus() + "]"));
            return row;
        }
    }
}

