/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public final class CostTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TariffContext, TreeContext, TvTariffWorkerContext> {
    private final int periodMode;
    private final int periodAmount;
    private final boolean periodAlign;
    private final boolean periodProportional;
    private final boolean ignoreBalance;
    private final boolean costFromProduct;
    private final BigDecimal cost;
    private final int costPeriod;

    public CostTariffTreeNode(int id, ParameterMap params) {
        super(id, params);
        BigDecimal cost;
        this.periodMode = params.getInt("periodMode", 0);
        this.periodAmount = params.getInt("periodAmount", 0);
        this.periodAlign = params.getInt("periodAlign", 0) > 0;
        this.periodProportional = params.getInt("periodProportional", 0) > 0;
        this.ignoreBalance = params.getInt("ignoreBalance", 0) > 0;
        boolean bl = this.costFromProduct = params.getInt("costFromProduct", 0) > 0;
        this.cost = this.periodAmount >= 0 ? (BigDecimal.ZERO.compareTo(cost = params.getBigDecimal("cost", BigDecimal.ZERO)) == 0 ? BigDecimal.ZERO : cost) : null;
        this.costPeriod = params.getInt("costPeriod", 0);
    }

    protected final int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest tvTariffRequest, TariffContext tariffContext, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        if (this.cost != null && tvTariffRequest.serviceCost != null) {
            BigDecimal outCost;
            if (this.costPeriod == 3 && this.periodMode == 5) {
                ((TvServiceCost)tvTariffRequest.serviceCost).dayToEndMonth = true;
            }
            BigDecimal inCost = this.cost;
            if (this.costFromProduct) {
                inCost = new JSONObject(((TvServiceCost)tvTariffRequest.serviceCost).getProductSpecRuntime().productSpec.getData()).optBigDecimal("cost", BigDecimal.ZERO);
            }
            ((TvServiceCost)tvTariffRequest.serviceCost).periodProportional = this.periodProportional;
            ((TvServiceCost)tvTariffRequest.serviceCost).ignoreBalance = this.ignoreBalance;
            if (this.costPeriod == 5 && this.periodMode == 3) {
                int daysCount = tvTariffRequest.getTime().getActualMaximum(5);
                ((TvServiceCost)tvTariffRequest.serviceCost).periodMode = this.periodMode;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAmount = this.periodAmount;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = this.periodAlign;
                outCost = inCost.divide(BigDecimal.valueOf(daysCount), tariffContext.mc);
            } else if (this.costPeriod == 3 && this.periodMode == 5) {
                ZonedDateTime productTimeFrom;
                int day = tvTariffRequest.getTime().get(5);
                int daysCount = tvTariffRequest.getTime().getActualMaximum(5);
                int days = daysCount - day + 1;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodMode = 3;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAmount = days;
                boolean bl = ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = !this.periodProportional;
                if (((TvServiceCost)tvTariffRequest.serviceCost).periodAlign && ((TvServiceCost)tvTariffRequest.serviceCost).getProductItem() != null && ((productTimeFrom = Instant.ofEpochMilli(((TvServiceCost)tvTariffRequest.serviceCost).getProductItem().productTimeFrom.getTime()).atZone(ZoneId.systemDefault())).getSecond() != 0 || productTimeFrom.getMinute() != 0 || productTimeFrom.getHour() != 0)) {
                    ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = false;
                }
                outCost = inCost.multiply(BigDecimal.valueOf(days), tariffContext.mc).divide(BigDecimal.valueOf(daysCount), tariffContext.mc);
            } else {
                ((TvServiceCost)tvTariffRequest.serviceCost).periodMode = this.periodMode;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAmount = this.periodAmount;
                ((TvServiceCost)tvTariffRequest.serviceCost).periodAlign = this.periodAlign;
                outCost = inCost;
            }
            ((TvServiceCost)tvTariffRequest.serviceCost).setCost(outCost);
        }
        return 1;
    }

    protected final int postExecuteImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TariffContext ctx, TreeContext treeContext, TvTariffWorkerContext workerContext, int executeResult) {
        return executeResult;
    }
}

