/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class BalanceSetRoundCorrector {
    private static final Logger log = LogManager.getLogger();
    private final Connection con;
    private final String tableName;
    private Map<Integer, Round> servicesRoundRules = new HashMap<Integer, Round>();

    public BalanceSetRoundCorrector(Connection con, Preferences moduleSetup, String tableName) {
        this.con = con;
        this.tableName = tableName;
        StringTokenizer st = new StringTokenizer(moduleSetup.get("set.balance.as.round.time", ""), ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] sids_round = token.split(":");
            if (sids_round.length != 2 && sids_round.length != 3) {
                log.error("Incorrect token: " + token);
                continue;
            }
            int round = Utils.parseInt((String)sids_round[1]);
            if (round <= 0) {
                log.error("Incorrect round factor.");
                continue;
            }
            int roundingMode = sids_round.length == 3 ? Utils.parseInt((String)sids_round[2], (int)2) : 2;
            if (roundingMode <= 0) {
                log.error("Incorrect rounding mode.");
                continue;
            }
            for (Integer sid : Utils.toIntegerList((String)sids_round[0])) {
                this.servicesRoundRules.put(sid, new Round(round, roundingMode));
            }
        }
    }

    public void correctAccounts(ServiceCostCache costCache) throws BGException {
        try {
            String query = "SELECT SUM(round_session_time), SUM(cost) FROM " + this.tableName + " WHERE cid=? AND sid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            log.debug("correctAccounts");
            for (CostSum costSum : costCache.getAmounts()) {
                Round round = this.servicesRoundRules.get(costSum.serviceId);
                if (round == null) continue;
                log.debug("costSum.cid" + costSum.contractId + "   |   costSum.sid=" + costSum.serviceId);
                ps.setInt(1, costSum.contractId);
                ps.setInt(2, costSum.serviceId);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    int seconds = rs.getInt(1);
                    BigDecimal cost = rs.getBigDecimal(2);
                    log.debug("seconds" + seconds);
                    log.debug("cost" + cost);
                    int roundSeconds = BigDecimal.valueOf(seconds).divide(round.round, round.roundingMode).multiply(round.round).intValue();
                    log.debug("roundSeconds" + roundSeconds);
                    costSum.cost = cost.divide(new BigDecimal(seconds), MathContext.DECIMAL128).multiply(new BigDecimal(roundSeconds)).setScale(5, RoundingMode.HALF_UP);
                    log.debug("costSum.cost" + costSum.cost);
                }
                rs.close();
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    static class Round {
        private final BigDecimal round;
        private final int roundingMode;

        public Round(int round, int roundingMode) {
            this.round = BigDecimal.valueOf(round);
            this.roundingMode = roundingMode;
        }
    }
}

