/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class CRMUtils {
    public static void sendRegisterEmail(RegisterCall call, String subject, Connection con, int userId) throws Exception {
        RegisterProblem problem;
        RegisterGroup group = new RegisterGroupManager(con).getGroupById(call.getGroupId());
        if (group == null || group.getEmail() == null || group.getEmail().trim().isEmpty()) {
            throw new BGMessageException("\u0423 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435\u0442 \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430!");
        }
        Document document = XMLUtils.newDocument();
        Element rootNode = XMLUtils.createElement((Document)document, (String)"data");
        rootNode.setAttribute("problem_id", String.valueOf(call.getProblemId()));
        Element header = XMLUtils.createElement((Element)rootNode, (String)"header");
        header.setAttribute("id", String.valueOf(call.getId()));
        CRMUtils.addUserData(call.getUserId(), call.getTime(), "dd.MM.yyyy HH:mm", header, "open");
        header.setAttribute("group", group.getTitle());
        header.setAttribute("contract", "-");
        header.setAttribute("object", "-");
        if (call.getContractId() > 0) {
            try (ContractDao contractDao = new ContractDao(con, userId);
                 ContractObjectDao contractObjectDao = new ContractObjectDao(con, userId);){
                Contract contract = (Contract)contractDao.get(call.getContractId());
                if (contract != null) {
                    header.setAttribute("contract", contract.getTitle());
                    ContractObject object = (ContractObject)contractObjectDao.get(call.getObjectId());
                    if (object != null) {
                        header.setAttribute("object", object.getTitle());
                    }
                }
            }
        }
        String query = "SELECT title FROM register_subject WHERE id=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, call.getTypeId());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    header.setAttribute("type", rs.getString(1));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        Element comment = XMLUtils.createElement((Element)rootNode, (String)"comment");
        XMLUtils.stringToLines((Element)comment, (String)call.getComment());
        RegisterProblemManager problemManager = new RegisterProblemManager(con);
        if (call.getProblemId() > 0 && (problem = problemManager.getProblemByID(call.getProblemId())) != null) {
            Element problemEl = XMLUtils.createElement((Element)rootNode, (String)"problem");
            comment = XMLUtils.createElement((Element)problemEl, (String)"comment");
            XMLUtils.stringToLines((Element)comment, (String)problem.getComment());
        }
        XSLManager.getInstance().transformAndSend("crm_register_call.xsl", (Source)new DOMSource(rootNode.getOwnerDocument()), null, "text/html", null, false, group.getEmail(), subject);
    }

    public static void addUserData(int uid, Date time, String format, Element el, String attrName) {
        User user = UserMap.getUser((Integer)uid);
        if (user != null && time != null) {
            StringBuffer message = new StringBuffer(20);
            message.append(TimeUtils.format((Date)time, (String)format));
            message.append(" (");
            message.append(user.getName());
            message.append(")");
            el.setAttribute(attrName, message.toString());
        }
    }
}

