/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.json.JSONArray;
import org.json.JSONException;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.sorm.common.JSONSerializationUtils;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class SormServicePanel
extends BGUPanel {
    private final SormService sormService;
    private final ModuleService moduleService;
    private List<InstalledInstanceModule> npayModules;
    private BGUList<InstalledInstanceModule> bgListModules;
    private BGTableModel<ServiceSorm> tableModel;
    private BGUTable table;
    boolean selectedAllServices = true;
    private final List<ServiceSorm> moduleServices = new ArrayList<ServiceSorm>();
    private final Dimension dimension = new Dimension(400, 150);

    public SormServicePanel(ClientContext context) {
        this.sormService = (SormService)context.getPort(SormService.class);
        this.moduleService = (ModuleService)context.getPort(ModuleService.class, 0);
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.npayModules = this.sormService.getInstanceModules("npay");
        for (InstalledInstanceModule npayModule : this.npayModules) {
            this.moduleServices.addAll(this.getNpayServices(npayModule.getModuleId()));
        }
        this.add(this.getModulesPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getTableServices(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private List<ServiceSorm> getNpayServices(int npayMid) {
        ArrayList<ServiceSorm> sormServiceList = new ArrayList<ServiceSorm>();
        try {
            this.moduleService.serviceList(npayMid).forEach(service -> sormServiceList.add(new ServiceSorm(service, false)));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433: " + ex.getMessage()));
        }
        return sormServiceList;
    }

    private JScrollPane getModulesPanel() {
        this.bgListModules = new BGUList();
        this.bgListModules.setData(this.npayModules);
        this.bgListModules.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InstalledInstanceModule selectedNpayModule = (InstalledInstanceModule)SormServicePanel.this.bgListModules.getSelectedValue();
                if (selectedNpayModule != null && SwingUtilities.isLeftMouseButton(e)) {
                    List<ServiceSorm> servicesOfSelectedModule = SormServicePanel.this.moduleServices.stream().filter(service -> service.getModuleId() == selectedNpayModule.getModuleId()).collect(Collectors.toList());
                    if (e.getClickCount() == 2) {
                        servicesOfSelectedModule.forEach(serviceSorm -> serviceSorm.setSelected(SormServicePanel.this.selectedAllServices));
                        SormServicePanel.this.tableModel.setData(servicesOfSelectedModule);
                        SormServicePanel.this.selectedAllServices = !SormServicePanel.this.selectedAllServices;
                    } else if (e.getClickCount() == 1) {
                        SormServicePanel.this.tableModel.setData(servicesOfSelectedModule);
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this.bgListModules);
        scrollPane.setMinimumSize(this.dimension);
        scrollPane.setPreferredSize(this.dimension);
        return scrollPane;
    }

    private JScrollPane getTableServices() {
        this.tableModel = new BGTableModel<ServiceSorm>("services"){

            protected void initColumns() {
                this.addColumn("ID", 30, 40, 40, "id", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 300, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", -1, 60, -1, "using", true);
                this.addColumn("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", -1, 60, -1, "isSelected", true);
                this.addColumn("\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442", -1, 60, -1, "inetServiceType", true);
                this.addColumn("\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u044f", -1, 60, -1, "phoneServiceType", true);
                this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, 300, -1, "description", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 6;
            }
        };
        this.table = new BGUTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ServiceSorm serviceSorm;
                if (SwingUtilities.isLeftMouseButton(e) && (serviceSorm = (ServiceSorm)SormServicePanel.this.tableModel.getSelectedRow()) != null) {
                    switch (SormServicePanel.this.table.getSelectedColumn()) {
                        case 3: {
                            serviceSorm.setSelected(!serviceSorm.isSelected());
                            break;
                        }
                        case 4: {
                            serviceSorm.setInetServiceType(!serviceSorm.isInetServiceType());
                            break;
                        }
                        case 5: {
                            serviceSorm.setPhoneServiceType(!serviceSorm.isPhoneServiceType());
                        }
                    }
                    SormServicePanel.this.table.repaint();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        Dimension dimension = new Dimension(1200, 150);
        scrollPane.setSize(dimension);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        return scrollPane;
    }

    public void buildConfig(Preferences config) {
        List selectedServices = this.moduleServices.stream().filter(ServiceSorm::isSelected).collect(Collectors.toList());
        if (Utils.isEmptyCollection(selectedServices)) {
            config.set("sorm.upload.services", new JSONArray().toString());
            return;
        }
        config.set("sorm.upload.services", JSONSerializationUtils.serializateListToString(selectedServices));
    }

    public void setSelectedModuleServices(Preferences config) {
        try {
            JSONArray jsonArray = new JSONArray(config.get("sorm.upload.services", ""));
            List savedServices = JSONSerializationUtils.convertJsonToList((String)jsonArray.toString(), ServiceSorm.class);
            this.moduleServices.forEach(service -> {
                for (ServiceSorm savedService : savedServices) {
                    if (service.getId() != savedService.getId() || service.getModuleId() != savedService.getModuleId()) continue;
                    service.setSelected(true);
                    service.setInetServiceType(savedService.isInetServiceType());
                    service.setPhoneServiceType(savedService.isPhoneServiceType());
                    service.setDescription(savedService.getDescription());
                }
            });
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.selectFirstElementInList();
    }

    public void selectFirstElementInList() {
        InstalledInstanceModule instanceModule = (InstalledInstanceModule)this.bgListModules.getModel().getElementAt(0);
        if (instanceModule != null) {
            this.bgListModules.setSelectedIndex(0);
            this.tableModel.setData(this.moduleServices.stream().filter(service -> service.getModuleId() == instanceModule.getModuleId()).collect(Collectors.toList()));
        }
    }
}

