/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.phone.server.action.ActionMailDispatch;
import ru.bitel.bgbilling.modules.phone.server.bean.Report;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionReportService
extends ActionMailDispatch {
    private static final HashMap<String, Integer> paramMap = new HashMap();

    @Override
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        super.doAction();
        if (this.html || this.showAll) {
            this.page.setPageSize(-1);
        }
        ReportManager reportManager = new ReportManager(this.con, this.mid);
        PagedList<Report> serviceReportList = reportManager.getServiceReportList(this.cid, this.items, this.date1, this.date2, this.noFree, this.page);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Report report : serviceReportList.list) {
            Element rep = this.createElement(data, "row");
            rep.setAttribute("item_id", String.valueOf(report.getClientItemId()));
            rep.setAttribute("item", report.getClientItem());
            rep.setAttribute("sid", String.valueOf(report.getDestCode()));
            rep.setAttribute("service", report.getDestination());
            rep.setAttribute("number", String.valueOf(report.getNumber()));
            rep.setAttribute("time", Utils.formatSessionTime((int)report.getTime()));
            rep.setAttribute("time_round", Utils.formatSessionTime((int)report.getTimeRound()));
            rep.setAttribute("cost", Utils.formatSessionCost((BigDecimal)report.getCost()));
        }
        this.setPageAttribute(table, serviceReportList.page);
        table.setAttribute("count", String.valueOf(serviceReportList.records));
        table.setAttribute("total_number", String.valueOf(((Report)serviceReportList.total).getNumber()));
        table.setAttribute("total_cost", Utils.formatCost((BigDecimal)((Report)serviceReportList.total).getCost()));
        float time = ((Report)serviceReportList.total).getTime();
        table.setAttribute("total_time", Utils.formatSessionTime((int)((Report)serviceReportList.total).getTime()) + " [" + Math.round(time / 60.0f) + "]");
        time = ((Report)serviceReportList.total).getTimeRound();
        table.setAttribute("total_time_round", Utils.formatSessionTime((int)((Report)serviceReportList.total).getTimeRound()) + " [" + Math.round(time / 60.0f) + "]");
        if (this.html) {
            this.rootNode.setAttribute("action", "DispatchDirect");
            if (this.csv) {
                this.rootNode.setAttribute("xslt", "phone_login_service_csv.xsl");
            } else {
                this.rootNode.setAttribute("xslt", "phone_login_service.xsl");
            }
            table.setAttribute("reportTitle", this.moduleSetup.get("phone.report.dispatchservice.title", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0430\u043c"));
            ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
            Contract contract = (Contract)contractDao.get(this.cid);
            contractDao.close();
            table.setAttribute("contractTitle", contract.getTitle());
            table.setAttribute("comment", contract.getComment());
            table.setAttribute("date1", TimeUtils.formatDate((Calendar)this.date1));
            table.setAttribute("date2", TimeUtils.formatDate((Calendar)this.date2));
            HashMap<String, Object> params = new HashMap<String, Object>();
            Iterator<Report> iter = serviceReportList.list.iterator();
            params.put("beans", new Iter.PublicIter(iter));
            params.put("lines", new CSVLine(iter));
            params.put("size", new Iter.BeanNodeList(serviceReportList.list.size()));
            this.transformerParameters = params;
            if (this.request != null) {
                this.request.setAttribute("bitel.billing.server.transformer.parameters", params);
            }
        }
    }

    static {
        paramMap.put("sid", 1);
        paramMap.put("item", 2);
        paramMap.put("service", 3);
        paramMap.put("number", 4);
        paramMap.put("time", 5);
        paramMap.put("time_round", 6);
        paramMap.put("cost", 7);
    }

    public static class CSVLine {
        private Iterator<Report> reports;
        private int[] mask;
        private final StringBuilder sb = new StringBuilder();

        public CSVLine(Iterator<Report> reportList) {
            this.reports = reportList;
        }

        public void init(String pattern) {
            String[] params = Utils.patternSemicolon.split(pattern);
            this.mask = new int[params.length];
            int i = 0;
            for (String param : params) {
                this.mask[i++] = paramMap.get(param);
            }
        }

        public String next() {
            this.sb.setLength(0);
            Report report = this.reports.next();
            for (int i : this.mask) {
                switch (i) {
                    case 1: {
                        this.sb.append(String.valueOf(report.getDestCode()));
                        break;
                    }
                    case 2: {
                        this.sb.append(String.valueOf(report.getClientItem()));
                        break;
                    }
                    case 3: {
                        this.sb.append(String.valueOf(report.getDestination()));
                        break;
                    }
                    case 4: {
                        this.sb.append(String.valueOf(report.getNumber()));
                        break;
                    }
                    case 5: {
                        this.sb.append(Utils.formatSessionTime((int)report.getTime()));
                        break;
                    }
                    case 6: {
                        this.sb.append(Utils.formatSessionTime((int)report.getTimeRound()));
                        break;
                    }
                    case 7: {
                        this.sb.append(String.valueOf(report.getCost()));
                    }
                }
                this.sb.append(';');
            }
            return this.sb.toString();
        }
    }
}

