/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.util.Comparator;
import java.util.List;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRecordType;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.common.client.BGUComboBox;

public class ForpostContractBasePanel
extends ContractBasePanel {
    protected int accountId = 0;

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    protected BGUComboBox<KeyValue> getMasterComboBox() {
        BGUComboBox comboBox = new BGUComboBox();
        try {
            ((ClientContext)this.getContext()).getDirectory(ForpostMaster.class).list().forEach(i -> comboBox.addItem((Object)new KeyValue(String.valueOf(i.getId()), i.getName())));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return comboBox;
    }

    protected BGUComboBox<KeyValue> getRecordTypeComboBox() {
        BGUComboBox comboBox = new BGUComboBox();
        try {
            ((ClientContext)this.getContext()).getDirectory(ForpostRecordType.class).list().forEach(i -> comboBox.addItem((Object)new KeyValue(String.valueOf(i.getId()), i.getName())));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return comboBox;
    }

    protected BGUComboBox<KeyValue> getModelComboBox() {
        BGUComboBox comboBox = new BGUComboBox();
        comboBox.addItem((Object)new KeyValue("0", "\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430"));
        try {
            List cameraBrands = ((ForpostService)((ClientContext)this.getContext()).getWebService(ForpostService.class)).forpostCameraBrandList();
            List cameraModels = ((ForpostService)((ClientContext)this.getContext()).getPort(ForpostService.class)).forpostCameraModelList();
            for (ForpostCameraModel cameraModel : cameraModels) {
                ForpostCameraBrand cameraBrand = cameraBrands.stream().filter(a -> a.getId() == cameraModel.getBrandId()).findFirst().orElse(null);
                cameraModel.setName((String)(cameraBrand != null ? cameraBrand.getName() + " " : "") + cameraModel.getName() + (String)(cameraModel.getUseCount() > 0 ? " [" + cameraModel.getUseCount() + "]" : ""));
            }
            cameraModels.sort(new Comparator<ForpostCameraModel>(){

                @Override
                public int compare(ForpostCameraModel o1, ForpostCameraModel o2) {
                    int result = o2.getUseCount() - o1.getUseCount();
                    if (result == 0) {
                        result = o1.getName().compareTo(o2.getName());
                    }
                    return result;
                }
            });
            cameraModels.forEach(i -> comboBox.addItem((Object)new KeyValue(String.valueOf(i.getId()), i.getName())));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return comboBox;
    }
}

