/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;

public abstract class EmptyRowSorter<M extends TableModel>
extends RowSorter<M> {
    private M model;
    private int maxSortKeys;
    protected List<RowSorter.SortKey> sortKeys;

    public EmptyRowSorter(M model) {
        this.model = model;
        this.maxSortKeys = 1;
    }

    public EmptyRowSorter(M model, int maxSortKeys) {
        this.model = model;
        this.maxSortKeys = maxSortKeys;
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public int getModelRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public int getViewRowCount() {
        return this.model.getRowCount();
    }

    public int getMaxSortKeys() {
        return this.maxSortKeys;
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return null;
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.model.getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    protected abstract boolean isSortable(int var1);

    @Override
    public void toggleSortOrder(int column) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            int sortIndex;
            List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
            }
            if (sortIndex == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                keys.add(0, sortKey);
            } else if (sortIndex == 0) {
                keys.set(0, this.toggle((RowSorter.SortKey)keys.get(0)));
            } else {
                keys.remove(sortIndex);
                keys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
            }
            if (keys.size() > this.getMaxSortKeys()) {
                keys = keys.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(keys);
        }
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey key) {
        if (key.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
        }
        if (key.getSortOrder() == SortOrder.DESCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.UNSORTED);
        }
        return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        List<RowSorter.SortKey> old = this.sortKeys;
        if (sortKeys != null && sortKeys.size() > 0) {
            int max = this.model.getColumnCount();
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < max) continue;
                throw new IllegalArgumentException("Invalid SortKey");
            }
            this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(sortKeys));
        } else {
            this.sortKeys = Collections.emptyList();
        }
        if (!this.sortKeys.equals(old)) {
            this.fireSortOrderChanged();
            this.sort();
        }
    }

    protected abstract void sort();
}

