/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class FileInfo {
    private long sourceSize = -1L;
    private long dbSize = -1L;
    private long sourceTime = -1L;
    private long dbTime = -1L;
    private Calendar calendar;
    private File file;

    public FileInfo(Calendar calendar) {
        this.setCalendar((Calendar)calendar.clone());
    }

    public String getPath(String fs) {
        if (fs == null) {
            fs = System.getProperty("file.separator");
        }
        return this.format("yyyy'" + fs + "'MM");
    }

    public String getFileName() {
        return this.format("dd'_'HH");
    }

    public String getLocalFileName() {
        return this.format("yyyy'_'MM'_'dd'_'HH");
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public String getSQLHourString() {
        return this.format("HH");
    }

    public String getSQLDateString() {
        return this.format("yyyy'-'MM'-'dd");
    }

    public String getSQLDateTimeString() {
        return this.format("yyyy'-'MM'-'dd HH':00:00'");
    }

    public String getYYYYMMDD() {
        return this.format("yyyyMMdd");
    }

    public String getYYYYMM() {
        return this.format("yyyyMM");
    }

    public long getSourceSize() {
        return this.sourceSize;
    }

    public long getSourceTime() {
        return this.sourceTime;
    }

    public File getFile() {
        return this.file;
    }

    public void setDbSize(long size) {
        this.dbSize = size;
    }

    public void setDbTime(long time) {
        this.dbTime = time;
    }

    public void setSourceSize(long size) {
        this.sourceSize = size;
    }

    public void setSourceTime(long time) {
        this.sourceTime = time;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        if (calendar == null) {
            return;
        }
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
    }

    public boolean needLoadFile() {
        return this.sourceSize != -1L && this.sourceTime != -1L;
    }

    public String toString() {
        return "path = " + this.getPath(null) + ";  fileName = " + this.getFileName() + " sourceSize = " + this.sourceSize + "; sourceTime = " + this.sourceTime;
    }

    private String format(String pattern) {
        if (this.calendar == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(this.calendar.getTime());
    }

    public long getDbSize() {
        return this.dbSize;
    }

    public long getDbTime() {
        return this.dbTime;
    }
}

