/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.ip;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.network.ip.IpAddressSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaConnectionCloseEvent;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.model.Page;

public class InetServIpUtils {
    private static final Logger logger = LogManager.getLogger();

    public static byte[] getStartAddressFromParent(InetServ parent, Preferences servTypeConfig) {
        int reserveFromStart = servTypeConfig.getInt("parent.ip.range.reserve.from.start", 0);
        byte[] addressFrom = parent.getAddressFrom();
        IpAddress.add((byte[])addressFrom, (long)reserveFromStart);
        return addressFrom;
    }

    public static byte[] getEndAddressFromParent(InetServ parent, Preferences servTypeConfig) {
        int reserveFromEnd = servTypeConfig.getInt("parent.ip.range.reserve.from.end", 0);
        byte[] addressTo = parent.getAddressTo();
        IpAddress.substract((byte[])addressTo, (int)reserveFromEnd);
        return addressTo;
    }

    public static void closeConnectionsWithIntersectionIP(InetServ inetServ, InetSessionDao inetSessionDao, Directory<InetServType> servTypeDirectory, InetSessionService inetSessionService, int moduleId) throws Exception {
        logger.debug("closeConnectionsWithIntersectionIP");
        if (inetServ.getAddressFrom() == null || inetServ.getIpResourceId() <= 0) {
            return;
        }
        if (inetServ.getDateTo() != null && TimeUtils.dateBefore((Date)inetServ.getDateTo(), (Date)new Date())) {
            return;
        }
        ArrayList<InetSessionLog> sessionList = new ArrayList<InetSessionLog>();
        if (inetServ.getAddressTo() == null) {
            List<InetSessionLog> list = inetSessionDao.listAsLog(servTypeDirectory.list(), null, null, null, null, null, null, IpAddress.toString((byte[])inetServ.getAddressFrom()), null, null, null, new Page(1, 5), 0, 0, true);
            for (InetSessionLog l : list) {
                if (l.getContractId() == inetServ.getContractId() || l.getIpResourceId() != inetServ.getIpResourceId() || !IpAddress.equals((byte[])l.getInetAddressBytes(), (byte[])inetServ.getAddressFrom())) continue;
                sessionList.add(l);
            }
        } else {
            byte[] address = inetServ.getAddressFrom();
            for (int i = 0; i < 10 && IpAddress.compare((byte[])address, (byte[])inetServ.getAddressTo()) <= 0; ++i) {
                List<InetSessionLog> list = inetSessionDao.listAsLog(servTypeDirectory.list(), null, null, null, null, null, null, IpAddress.toString((byte[])address), null, null, null, new Page(1, 5), 0, 0, true);
                for (InetSessionLog l : list) {
                    if (l.getContractId() == inetServ.getContractId() || l.getIpResourceId() != inetServ.getIpResourceId() || !IpRange.inRange((byte[])l.getInetAddressBytes(), (byte[])l.getInetAddressBytes(), (byte[])inetServ.getAddressFrom(), (byte[])inetServ.getAddressTo())) continue;
                    sessionList.add(l);
                }
                address = IpAddress.newAndIncrement((byte[])address);
            }
        }
        for (InetSessionLog l : sessionList) {
            logger.info("Found session with same IP/resource on another contract. Try to close it. " + l);
            EventProcessor.getInstance().publish((Event)new InetSaConnectionCloseEvent(moduleId, 0, l.toConnection()));
            inetSessionService.connectionFinish(l.getContractId(), l.getConnectionId());
        }
    }

    public static void flowStaticSubnet(List<IpNet> result, IpNet net) {
        logger.debug("Add static subnet to Netflow listener");
        boolean exists = false;
        for (IpNet n : result) {
            if (n.getMask() != net.getMask() || !IpAddress.equals((byte[])n.getSubnet(), (byte[])net.getSubnet())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            result.add(net);
        }
    }

    public static void setFramedIPAddress(RadiusListenerWorker<?> radiusListenerWorker, RadiusPacket response, int ipResourceId, byte[] ipAddress) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Setting ip for the response: %s", IpAddress.toString((byte[])ipAddress)));
        }
        if (ipAddress.length == 4) {
            response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, Utils.convertBytesToInt((byte[])ipAddress)));
        } else {
            response.setAttribute(new RadiusAttribute(-1, 97, 0, (Object)new IpNet(ipAddress, 64)));
        }
        radiusListenerWorker.getIpAddressSet().setResourceId(ipResourceId);
        radiusListenerWorker.getIpAddressSet().setAddress(ipAddress);
    }

    public static void setFramedIPv6Prefix(RadiusListenerWorker<?> radiusListenerWorker, RadiusPacket response, int ipResourceId, byte[] prefix, short prefixLength) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Setting ipv6 prefix for the response: %s / %d", IpAddress.toString((byte[])prefix), prefixLength));
        }
        response.setAttribute(new RadiusAttribute(-1, 97, 0, (Object)new IpNet(prefix, (int)prefixLength)));
        IpAddressSet ipAddressSet = radiusListenerWorker.getIpAddressSet();
        ipAddressSet.setPrefixResourceId(ipResourceId);
        ipAddressSet.setPrefix(prefix);
        ipAddressSet.setPrefixLength(prefixLength);
    }

    public static void setDelegatedIPv6Prefix(RadiusListenerWorker<?> radiusListenerWorker, RadiusPacket response, int ipResourceId, byte[] prefix, short prefixLength) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Setting ipv6 delegated prefix for the response: %s / %d", IpAddress.toString((byte[])prefix), prefixLength));
        }
        response.setAttribute(new RadiusAttribute(-1, 123, 0, (Object)new IpNet(prefix, (int)prefixLength)));
        IpAddressSet ipAddressSet = radiusListenerWorker.getIpAddressSet();
        ipAddressSet.setDelegatedPrefixResourceId(ipResourceId);
        ipAddressSet.setDelegatedPrefix(prefix);
        ipAddressSet.setDelegatedPrefixLength(prefixLength);
    }
}

