/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.common.service.DrWebService;
import ru.bitel.bgbilling.modules.drweb.server.bean.DrWebManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.TariffAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.tasks.Recalculator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.drweb.common.service.DrWebService")
public class DrWebServiceImpl
extends AbstractService
implements DrWebService {
    public List<TariffAVD> tariffAVDList(int contractId, boolean forNew) throws Exception {
        Connection con = this.getConnection();
        ArrayList<TariffAVD> tariffAVDs = new ArrayList<TariffAVD>();
        TariffAVDManager tariffManager = new TariffAVDManager(con, this.moduleId);
        Contract contract = new ContractManager(con).getContractById(contractId);
        if (contract == null) {
            return tariffManager.getListAll();
        }
        for (TariffAVD tariff : tariffManager.getListAll()) {
            String groupStr = tariff.getGroupForView();
            if (!Utils.isEmptyString((String)groupStr)) {
                long grTariff = Utils.enumToMask((String)groupStr);
                if ((contract.getGroups() & grTariff) == 0L) continue;
            }
            if (!forNew && tariff.isOnlyForNew()) continue;
            Date date = new Date();
            Date from = tariff.getDateFromView();
            Date to = tariff.getDateToView();
            if (from != null && !TimeUtils.dateBeforeOrEq((Date)from, (Date)date) || to != null && !TimeUtils.dateBeforeOrEq((Date)date, (Date)to)) continue;
            tariffAVDs.add(tariff);
        }
        return tariffAVDs;
    }

    public int tariffAVDUpdate(TariffAVD tariffAVD) throws Exception {
        new TariffAVDManager(this.getConnection(), this.moduleId).update(tariffAVD);
        return tariffAVD.getId();
    }

    public void tariffAVDDelete(int tariffId) throws Exception {
        new TariffAVDManager(this.getConnection(), this.moduleId).delete(tariffId);
    }

    public List<AgentAVD> agentAVDList(int contractId) throws Exception {
        DrWebManager manager = new DrWebManager(this.getConnection(), (ParameterMap)this.getModuleSetup(), this.moduleId);
        if (contractId > 0) {
            return manager.getAgentList(contractId);
        }
        return manager.getAgentListAll();
    }

    public void agentAVDChangeTariff(int agentId, int tariffId) throws Exception {
        DrWebManager manager = new DrWebManager(this.getConnection(), (ParameterMap)this.getModuleSetup(), this.moduleId);
        AgentAVD agent = manager.getAgent(agentId);
        if (tariffId != -1) {
            manager.toChangeTariff(agent, tariffId);
        }
    }

    public void agentAVDBlock(int agentId, int monthCount) throws Exception {
        DrWebManager manager = new DrWebManager(this.getConnection(), (ParameterMap)this.getModuleSetup(), this.moduleId);
        AgentAVD agent = manager.getAgent(agentId);
        if (monthCount != -1) {
            manager.blockAgent(agent, monthCount);
        }
    }

    public void agentAVDDelete(int agentId) throws Exception {
        DrWebManager manager = new DrWebManager(this.getConnection(), (ParameterMap)this.getModuleSetup(), this.moduleId);
        manager.deleteAgent(manager.getAgent(agentId));
    }

    public void agentAVDActive(int agentId) throws Exception {
        DrWebManager manager = new DrWebManager(this.getConnection(), (ParameterMap)this.getModuleSetup(), this.moduleId);
        manager.activeAgent(manager.getAgent(agentId));
    }

    public void agentAVDRecalculate(String email, List<Integer> contractIds, String comment, Date startMonth) throws Exception {
        Calendar startMonthCalendar = TimeUtils.convertDateToCalendar((Date)startMonth);
        if (this.moduleId < 0 || startMonthCalendar == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 moduleId=" + this.moduleId + "; date=" + startMonthCalendar);
        }
        if (TimeUtils.monthsDelta((Calendar)new GregorianCalendar(), (Calendar)startMonthCalendar) > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0437\u0430 \u0431\u0443\u0434\u0443\u0449\u0438\u0435 \u043c\u0435\u0441\u044f\u0446\u044b!");
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new Recalculator(this.moduleId, startMonthCalendar, Utils.toString(contractIds), email, comment));
    }

    public void agentAVDClear(List<Integer> contractIds, Date startMonth) throws Exception {
        Connection con = this.getConnection();
        try (ServiceDao serviceDao = new ServiceDao(con);){
            Calendar startMonthCalendar = TimeUtils.convertDateToCalendar((Date)startMonth);
            startMonthCalendar = TimeUtils.getStartMonth((Calendar)startMonthCalendar);
            List list = serviceDao.list(this.moduleId);
            String sidList = Utils.toString(list.stream().map(a -> a.getId()).toList());
            String cids = Utils.toString(contractIds);
            String querySelect = "SELECT DISTINCT cid FROM contract_account WHERE sid IN ( " + sidList + " ) AND yy=? AND mm=?";
            if (Utils.notBlankString((String)cids)) {
                querySelect = querySelect + " AND cid IN ( " + cids + " )";
            }
            String queryDelete = "DELETE FROM contract_account WHERE sid IN ( " + sidList + " ) AND yy=? AND mm=?";
            if (Utils.notBlankString((String)cids)) {
                queryDelete = queryDelete + " AND cid IN ( " + cids + " )";
            }
            try (PreparedStatement psSelect = con.prepareStatement(querySelect);
                 PreparedStatement psDelete = con.prepareStatement(queryDelete);
                 BalanceUtils balanceUtils = new BalanceUtils(con);){
                int yy = startMonthCalendar.get(1);
                int mm = startMonthCalendar.get(2) + 1;
                HashSet<Integer> contracts = new HashSet<Integer>();
                psSelect.setInt(1, yy);
                psSelect.setInt(2, mm);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        contracts.add(rs.getInt(1));
                    }
                }
                psDelete.setInt(1, yy);
                psDelete.setInt(2, mm);
                psDelete.executeUpdate();
                for (Integer cid : contracts) {
                    balanceUtils.setBalanceFromAccount(cid.intValue(), startMonthCalendar);
                }
            }
        }
    }
}

