/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.server.RangeMapCache;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.modules.phone.server.bean.CalculateClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.util.Ranger;

public class ClientItemFinder {
    private List<CalculateClientItem> operItemList = new ArrayList<CalculateClientItem>();
    private List<CalculateClientItem> portItemList = new ArrayList<CalculateClientItem>();
    private List<CalculateClientItem> phoneItemList = new ArrayList<CalculateClientItem>();
    private Map<String, CalculateClientItem> portItemMap = new HashMap<String, CalculateClientItem>();
    private Map<String, CalculateClientItem> phoneItemMap = new HashMap<String, CalculateClientItem>();
    private RangeMapCache rangeMapCache;
    private Map<Integer, Set<CalculateClientItem.ContractInfo>> subContractMap = new HashMap<Integer, Set<CalculateClientItem.ContractInfo>>();

    private ClientItemFinder() {
    }

    public ClientItemFinder(Connection con, int mid, int sourceId, Calendar date1, Calendar date2, String cids) {
        Date sqlDate1 = TimeUtils.convertCalendarToSqlDate((Calendar)date1);
        Date sqlDate2 = TimeUtils.convertCalendarToSqlDate((Calendar)date2);
        String joinPart = " INNER JOIN phone_client_item_" + mid + " AS item  ON t.item_id=item.id AND item.source_id=" + sourceId + " AND (item.date1 IS NULL OR item.date1<='" + TimeUtils.formatSQLDate((Calendar)date2) + "')  AND (item.date2 IS NULL OR item.date2>='" + TimeUtils.formatSQLDate((Calendar)date1) + "')  INNER JOIN contract ON item.cid=contract.id";
        if (cids != null) {
            joinPart = joinPart + " WHERE contract.id IN (" + cids + ") ";
        }
        Object query = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int lastSuperId = 0;
            TreeSet<CalculateClientItem.ContractInfo> lastSubSet = null;
            query = cids == null ? "SELECT scid, id, title FROM contract WHERE (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2) AND scid>0 AND sub_mode=? ORDER BY scid" : "SELECT scid, id, title FROM contract WHERE contract.id IN (" + cids + ") OR contract.scid IN (" + cids + ") AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2) AND scid>0 AND sub_mode=? ORDER BY scid";
            ps = con.prepareStatement((String)query);
            ps.setDate(1, sqlDate2);
            ps.setDate(2, sqlDate1);
            ps.setInt(3, 1);
            rs = ps.executeQuery();
            while (rs.next()) {
                int superId = rs.getInt(1);
                CalculateClientItem.ContractInfo contractInfo = new CalculateClientItem.ContractInfo(rs.getInt(2), rs.getString(3));
                if (superId != lastSuperId) {
                    lastSubSet = new TreeSet<CalculateClientItem.ContractInfo>(new Comparator<CalculateClientItem.ContractInfo>(){

                        @Override
                        public int compare(CalculateClientItem.ContractInfo o1, CalculateClientItem.ContractInfo o2) {
                            return o1.id - o2.id;
                        }
                    });
                    this.subContractMap.put(superId, lastSubSet);
                    lastSuperId = superId;
                }
                lastSubSet.add(contractInfo);
            }
            ps.close();
            query = "SELECT t.port, item.id, item.cid, item.date1, item.date2, contract.title FROM phone_item_port_" + mid + " AS t " + joinPart + " ORDER BY item.id";
            ps = con.prepareStatement((String)query);
            rs = ps.executeQuery();
            this.loadPoints(rs, this.portItemList, this.portItemMap);
            ps.close();
            query = "SELECT t.number, item.id, item.cid, item.date1, item.date2, contract.title FROM phone_item_number_" + mid + " AS t " + joinPart + " ORDER BY item.id";
            ps = con.prepareStatement((String)query);
            rs = ps.executeQuery();
            this.loadPoints(rs, this.phoneItemList, this.phoneItemMap);
            ps.close();
            query = "SELECT item.id, item.cid,  rule.oper_fromports, rule.oper_toports, rule.oper_fromprefs, rule.oper_toprefs, rule.oper_not_fromprefs, rule.oper_not_toprefs, rule.oper_service_id,  rule.oper_from_range, rule.oper_to_range,   rule.oper_not_from_range, rule.oper_not_to_range,  rule.fromports_regexp, rule.toports_regexp, rule.oper_fromrangemap, rule.oper_torangemap, rule.oper_notfromrangemap, rule.oper_nottorangemap,  contract.title, item.date1, item.date2   FROM phone_client_item_" + mid + " AS item  LEFT JOIN phone_item_rule_data_" + mid + " AS rule ON item.id=rule.item_id  INNER JOIN contract ON item.cid=contract.id  WHERE type=? AND source_id=?  AND (item.date1 IS NULL OR item.date1<=?)  AND (item.date2 IS NULL OR item.date2>=?)";
            if (cids != null) {
                query = (String)query + " AND contract.id IN (" + cids + ") ";
            }
            ps = con.prepareStatement((String)query);
            ps.setInt(1, 2);
            ps.setInt(2, sourceId);
            ps.setDate(3, sqlDate2);
            ps.setDate(4, sqlDate1);
            rs = ps.executeQuery();
            while (rs.next()) {
                ClientItem item = new ClientItem();
                item.setType(2);
                item.setId(rs.getInt(1));
                item.setContractId(rs.getInt(2));
                item.setOperFromPorts(Utils.toList((String)rs.getString(3)));
                item.setOperToPorts(Utils.toList((String)rs.getString(4)));
                item.setOperFromPrefs(rs.getString(5));
                item.setOperToPrefs(rs.getString(6));
                item.setOperNotFromPrefs(rs.getString(7));
                item.setOperNotToPrefs(rs.getString(8));
                item.setOperServiceId(rs.getInt(9));
                item.setOperFromRange(rs.getString(10));
                item.setOperToRange(rs.getString(11));
                item.setOperNotFromRange(rs.getString(12));
                item.setOperNotToRange(rs.getString(13));
                item.setOperFromPortsRegexp(rs.getString(14));
                item.setOperToPortsRegexp(rs.getString(15));
                item.setOperFromRangeMapIds(rs.getString(16));
                item.setOperToRangeMapIds(rs.getString(17));
                item.setOperNotFromRangeMapIds(rs.getString(18));
                item.setOperNotToRangeMapIds(rs.getString(19));
                CalculateClientItem.ContractInfo contract = new CalculateClientItem.ContractInfo(item.getContractId(), rs.getString(20));
                CalculateClientItem calculateItem = new CalculateClientItem(item, contract, null);
                calculateItem.date1 = TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate(21));
                calculateItem.date2 = TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate(22));
                this.operItemList.add(calculateItem);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.subContractMap = null;
    }

    private void loadPoints(ResultSet rs, List<CalculateClientItem> list, Map<String, CalculateClientItem> usedMap) throws SQLException {
        CalculateClientItem lastCalculateItem = null;
        while (rs.next()) {
            String key = rs.getString(1);
            int itemId = rs.getInt(2);
            int cid = rs.getInt(3);
            Calendar date1 = TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate(4));
            Calendar date2 = TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate(5));
            String contractTitle = rs.getString(6);
            CalculateClientItem calculateItem = null;
            if (lastCalculateItem != null && lastCalculateItem.itemId == itemId) {
                calculateItem = lastCalculateItem;
                calculateItem.keys.add(key);
            } else {
                ClientItem item = new ClientItem();
                item.setType(1);
                item.setId(itemId);
                item.setContractId(cid);
                CalculateClientItem.ContractInfo contract = new CalculateClientItem.ContractInfo(cid, contractTitle);
                calculateItem = new CalculateClientItem(item, contract, this.subContractMap.get(contract.id));
                calculateItem.keys.add(key);
                calculateItem.date1 = date1;
                calculateItem.date2 = date2;
                list.add(calculateItem);
            }
            usedMap.put(key, calculateItem);
            lastCalculateItem = calculateItem;
        }
    }

    public CalculateClientItem findPoint(LogRecord record, boolean byToNumber) {
        CalculateClientItem result = null;
        if (byToNumber) {
            result = this.phoneItemMap.get(record.toNumber164);
        } else {
            result = this.portItemMap.get(record.fromPort);
            if (result == null) {
                result = this.phoneItemMap.get(record.fromNumber164);
            }
        }
        return result;
    }

    public List<CalculateClientItem> findRuleList(LogRecord record, RangeMapCache rangeMapCache) {
        ArrayList<CalculateClientItem> result = new ArrayList<CalculateClientItem>(2);
        for (CalculateClientItem operItem : this.operItemList) {
            if (!operItem.check(record, rangeMapCache)) continue;
            result.add(operItem);
        }
        return result;
    }

    public String getItemCount() {
        StringBuilder result = new StringBuilder();
        result.append("By num: ");
        result.append(this.phoneItemMap.size());
        result.append("; by port: ");
        result.append(this.portItemMap.size());
        result.append("; rules: ");
        result.append(this.operItemList.size());
        return result.toString();
    }

    public String getItemDetail() {
        StringBuilder result = new StringBuilder();
        result.append("Ports: ");
        for (String port : this.portItemMap.keySet()) {
            result.append(port);
            result.append(" ");
        }
        result.append("\nNumbers: ");
        for (String num : this.phoneItemMap.keySet()) {
            result.append(num);
            result.append(" ");
        }
        return result.toString();
    }

    public ClientItemFinder sub(Connection con, int moduleId, Calendar hour) throws BGException {
        Calendar date1 = Calendar.getInstance();
        date1.setTime(hour.getTime());
        date1.set(11, 0);
        Calendar date2 = date1;
        ClientItemFinder result = new ClientItemFinder();
        result.setRangeMapCache(RangeMapCache.getInstance((Connection)con, (int)moduleId, (Calendar)hour));
        Ranger<CalculateClientItem, Calendar> ranger = new Ranger<CalculateClientItem, Calendar>(){

            public Calendar getMaxValue(CalculateClientItem r) {
                return r.date2;
            }

            public Calendar getMinValue(CalculateClientItem r) {
                return r.date1;
            }
        };
        List portItemList = RangeUtils.subListContains(this.portItemList, (Ranger)ranger, (Comparable)date1, (Comparable)date2);
        List phoneItemList = RangeUtils.subListContains(this.phoneItemList, (Ranger)ranger, (Comparable)date1, (Comparable)date2);
        List operItemList = RangeUtils.subListContains(this.operItemList, (Ranger)ranger, (Comparable)date1, (Comparable)date2);
        result.portItemList.addAll(portItemList);
        result.phoneItemList.addAll(phoneItemList);
        result.operItemList.addAll(operItemList);
        for (CalculateClientItem item : result.portItemList) {
            item.tariffInit = false;
            for (String key : item.keys) {
                result.portItemMap.put(key, item);
            }
        }
        for (CalculateClientItem item : result.phoneItemList) {
            item.tariffInit = false;
            for (String key : item.keys) {
                result.phoneItemMap.put(key, item);
            }
        }
        for (CalculateClientItem item : result.operItemList) {
            item.tariffInit = false;
        }
        return result;
    }

    public void setRangeMapCache(RangeMapCache rangeMapCache) {
        this.rangeMapCache = rangeMapCache;
    }

    public RangeMapCache getRangeMapCache() {
        return this.rangeMapCache;
    }
}

