/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action.web;

import bitel.billing.server.contract.action.base.ActionBase;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.CancelTariffEvent;
import ru.bitel.bgbilling.kernel.event.events.ChangeTariffByTaskEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.GetChangeTariffDatesEvent;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Sorter;

public class ActionChangeTariff
extends ActionBase {
    private Map<Integer, TariffGroup> groupSet = null;
    private Map<Integer, TariffPlan> tariffMap = null;
    private List<ContractTariff> contractTariffList = null;
    private List<PersonalTariff> personalTariffList = null;
    private int step = 0;
    int groupId = -1;
    int toTariffId = -1;
    String toTariffTitle = null;
    List<ClientItem> points = null;
    int pointId = -1;

    public void doAction() throws Exception {
        this.pointId = this.getIntParameter("pointId", -1);
        if (this.pointId > 0) {
            this.doChange();
        }
        if (this.pointId < 0) {
            Date now = new Date();
            this.points = new ClientItemManager(this.con, this.mid).getItemList(this.cid, 1, false, 0, now, now);
        }
        this.setData();
    }

    private void doChange() throws Exception {
        try (TariffGroupDao tariffGroupManager = new TariffGroupDao(this.con);
             TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);){
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
            ArrayList<Integer> contractGroups = new ArrayList<Integer>();
            ContractTariffGroup contractTariffGroup = (ContractTariffGroup)new ContractTariffGroupDao(this.con).get(this.cid);
            if (contractTariffGroup != null) {
                contractGroups.add(contractTariffGroup.getTariffGroupId());
            }
            this.groupSet = new HashMap<Integer, TariffGroup>();
            if (contractGroups.size() > 0) {
                this.groupSet = tariffGroupManager.getTariffGroupMap(Utils.toString(contractGroups));
            }
            this.tariffMap = tariffPlanDao.getTariffPlanMap();
            try {
                this.groupId = this.getIntParameter("tariff_group", -1);
                this.toTariffId = this.getIntParameter("to_tariff", -1);
                this.step = this.getIntParameter("step", 0);
                String command = this.getParameter("command", "");
                if ("change".equals(command)) {
                    if (this.step == 0) {
                        if (this.toTariffId == -1) {
                            this.dataMap.put("error", "The tariff has not been chosen");
                            throw new BGException("\u041d\u0435 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0430\u0440\u0438\u0444");
                        }
                        TariffPlan plan = this.tariffMap.get(this.toTariffId);
                        if (plan != null) {
                            this.toTariffTitle = plan.getTitle();
                        }
                        this.step = 1;
                    } else {
                        this.changeTariff(contractTariffDao);
                        this.step = 0;
                        this.pointId = -1;
                    }
                } else if ("cancel".equals(command)) {
                    this.cancelChangeTariff(contractTariffDao);
                    this.step = 0;
                    this.pointId = -1;
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                Element error = this.createElement(this.rootNode, "error");
                this.stringToLines(error, ex.getMessage());
            }
            this.contractTariffList = contractTariffDao.list(this.cid, (LocalDate)null, this.mid, this.pointId);
            this.personalTariffList = new PersonalTariffManager(this.con).getPersonalTariffList(this.cid);
        }
    }

    private void cancelChangeTariff(ContractTariffDao contractTariffDao) throws Exception {
        int contractTariffId = this.getIntParameter("contractTariffId", -1);
        ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(contractTariffId);
        if (contractTariff == null) {
            this.dataMap.put("error", "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariffId + ")");
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariffId + ")");
        }
        if (contractTariff.getContractId() != this.cid) {
            this.dataMap.put("error", "\u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u0442\u0430\u0440\u0438\u0444");
            throw new BGException("\u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u0442\u0430\u0440\u0438\u0444");
        }
        if (contractTariff.getReplacedFromContractTariffId() <= 0) {
            this.dataMap.put("error", "\u041d\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c");
            throw new BGException("\u041d\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c");
        }
        ContractTariff contractTariffPrevious = (ContractTariff)contractTariffDao.get(contractTariff.getReplacedFromContractTariffId());
        if (contractTariffPrevious == null) {
            this.dataMap.put("error", "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
        }
        CancelTariffEvent event = new CancelTariffEvent(this.userId.intValue(), this.cid, contractTariff, contractTariffPrevious);
        event = (CancelTariffEvent)EventProcessor.getInstance().request((QueueEvent)event);
        if (Utils.notBlankString((String)event.getError())) {
            Element error = this.createElement(this.rootNode, "error");
            this.stringToLines(error, event.getError());
            this.dataMap.put("error", event.getError());
        }
        if (Utils.notBlankString((String)event.getMessage())) {
            Element message = this.createElement(this.rootNode, "message");
            this.stringToLines(message, event.getMessage());
            this.dataMap.put("message", event.getMessage());
        }
        if (!event.isProcessed()) {
            contractTariffPrevious.getPeriod().setDateTo(null);
            contractTariffDao.update((Object)contractTariffPrevious);
            contractTariffDao.delete(contractTariff.getId());
        }
        this.context.publishAfterCommit((Event)new ContractTariffChangedEvent(this.cid));
        this.context.publishAfterCommit((Event)new ContractTariffUpdateEvent(this.userId.intValue(), this.cid, contractTariffPrevious, false));
        this.context.publishAfterCommit((Event)new ContractTariffDeleteEvent(this.userId.intValue(), this.cid, contractTariff.getId()));
    }

    private void changeTariff(ContractTariffDao contractTariffDao) throws Exception {
        boolean changeAllow;
        Calendar fromDate = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("from_date"));
        if (this.toTariffId == -1) {
            this.dataMap.put("error", "The tariff has not been chosen");
            throw new BGException("\u041d\u0435 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0430\u0440\u0438\u0444");
        }
        TariffPlan toTariff = this.tariffMap.get(this.toTariffId);
        if (toTariff == null) {
            this.dataMap.put("error", "Not found tariff with id=" + this.toTariffId);
            throw new BGException("Not found tariff with id=" + this.toTariffId);
        }
        if (!toTariff.isUsed()) {
            this.dataMap.put("error", "Tariff not using");
            throw new BGException("Tariff not using");
        }
        TariffGroup tariffGroup = this.groupSet.get(this.groupId);
        if (tariffGroup == null) {
            this.dataMap.put("error", "Not found tariff group with id=" + this.groupId);
            throw new BGException("Not found tariff group with id=" + this.groupId);
        }
        if (!this.tariffGroupGetPlanIdList(tariffGroup).contains(this.toTariffId)) {
            this.dataMap.put("error", "Tariff not in group");
            throw new BGException("Tariff not in group");
        }
        if (fromDate == null) {
            this.dataMap.put("error", "From date not defined");
            throw new BGException("From date not defined");
        }
        ContractTariff fromContractTariff = this.getFromTariff(contractTariffDao, TimeUtils.convertDateToLocalDate((Date)fromDate.getTime()), tariffGroup);
        GetChangeTariffDatesEvent dateListEvent = new GetChangeTariffDatesEvent(this.userId.intValue(), this.cid, tariffGroup, new Date(), fromContractTariff.getTariffPlanId(), this.toTariffId);
        dateListEvent = (GetChangeTariffDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateListEvent);
        int transferMode = tariffGroup.getTransferMode();
        boolean bl = changeAllow = transferMode == 1 || transferMode == 4 && TimeUtils.dateBefore((Calendar)new GregorianCalendar(), (Calendar)fromDate) || transferMode == 3 && fromDate.get(5) == 1 || transferMode == 2 && fromDate.get(7) == 2;
        if (dateListEvent.getDateList() != null) {
            Date date;
            changeAllow = false;
            Iterator iterator = dateListEvent.getDateList().iterator();
            while (iterator.hasNext() && !(changeAllow = TimeUtils.dateEqual((Calendar)fromDate, (Calendar)TimeUtils.convertDateToCalendar((Date)(date = (Date)iterator.next()))))) {
            }
        }
        if (changeAllow) {
            ChangeTariffByTaskEvent event = new ChangeTariffByTaskEvent(this.userId.intValue(), this.cid, tariffGroup, fromContractTariff, toTariff, fromDate.getTime());
            event = (ChangeTariffByTaskEvent)EventProcessor.getInstance().request((QueueEvent)event);
            if (Utils.notBlankString((String)event.getError())) {
                Element error = this.createElement(this.rootNode, "error");
                this.stringToLines(error, event.getError());
                this.dataMap.put("error", event.getError());
            }
            if (Utils.notBlankString((String)event.getMessage())) {
                Element message = this.createElement(this.rootNode, "message");
                this.stringToLines(message, event.getMessage());
                this.dataMap.put("message", event.getMessage());
            }
            ContractTariff newTariff = null;
            if (!event.isProcessed() && fromContractTariff != null) {
                fromContractTariff.getPeriod().setDateTo(TimeUtils.getPrevDay((Calendar)fromDate).getTime());
                if (TimeUtils.dateBefore((Date)fromContractTariff.getPeriod().getDateTo(), (Date)fromContractTariff.getPeriod().getDateFrom())) {
                    contractTariffDao.delete(fromContractTariff.getId());
                } else {
                    contractTariffDao.update((Object)fromContractTariff);
                }
                newTariff = ContractTariff.builder().setContractId(this.cid).setPeriod(new Period(TimeUtils.convertCalendarToDate((Calendar)fromDate), null)).setComment("\u0421\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0447\u0435\u0440\u0435\u0437 Web").setPosition(tariffGroup.getPos()).setTariffPlanId(this.toTariffId).setReplacedFromContractTariffId(fromContractTariff.getId()).setEntityModuleId(this.mid).setEntityId(this.pointId).build();
                contractTariffDao.update((Object)newTariff);
            }
            this.context.publishAfterCommit((Event)new ContractTariffChangedEvent(this.cid));
            if (newTariff != null) {
                this.context.publishAfterCommit((Event)new ContractTariffUpdateEvent(this.userId.intValue(), this.cid, newTariff, true));
            }
        } else {
            this.getLogger().error("Change tariff not allow from date " + TimeUtils.formatDate((Calendar)fromDate));
        }
    }

    private ContractTariff getFromTariff(ContractTariffDao contractTariffManager, LocalDate fromDate, TariffGroup tariffGroup) throws Exception {
        ContractTariff fromContractTariff = null;
        List onDateTariffList = contractTariffManager.list(this.cid, fromDate, this.mid, this.pointId);
        for (ContractTariff contractTariff : onDateTariffList) {
            TariffGroup group = this.findGroup(contractTariff.getTariffPlanId());
            if (group != tariffGroup || contractTariff.getTariffPlanId() == this.toTariffId) continue;
            if (contractTariff.getPeriod().getDateTo() == null) {
                fromContractTariff = contractTariff;
                break;
            }
            this.dataMap.put("error", "Contract already have not closed tariff from this group");
            throw new BGException("Contract already have not closed tariff from this group");
        }
        return fromContractTariff;
    }

    private TariffGroup findGroup(int tariffPlanID) {
        TariffGroup group = null;
        for (TariffGroup tg : this.groupSet.values()) {
            if (!this.tariffGroupGetPlanIdList(tg).contains(tariffPlanID)) continue;
            group = tg;
            break;
        }
        return group;
    }

    private List<Integer> tariffGroupGetPlanIdList(TariffGroup tariffGroup) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List listTGT = tariffGroup.getPlanList();
        if (listTGT != null) {
            for (TariffGroupTariff tariffGroupTariff : listTGT) {
                result.add(tariffGroupTariff.getId());
            }
        }
        return result;
    }

    protected void setDataForXslt() throws BGException {
        Element history = this.createElement(this.rootNode, "history");
        this.rootNode.setAttribute("step", String.valueOf(this.step));
        this.rootNode.setAttribute("to_tariff_title", this.toTariffTitle);
        this.rootNode.setAttribute("to_tariff", String.valueOf(this.toTariffId));
        this.rootNode.setAttribute("pointId", String.valueOf(this.pointId));
        if (this.points != null) {
            Element itemsEl = this.createElement(this.rootNode, "points");
            for (ClientItem item : this.points) {
                this.addListItem(itemsEl, item.getId(), item.toStringWithoutSource() + item.getPeriod());
                this.createElement(history, "row");
            }
            this.rootNode.setAttribute("point", "1");
            return;
        }
        Sorter<ContractTariff, PersonalTariff, Calendar> sorter = new Sorter<ContractTariff, PersonalTariff, Calendar>(this.contractTariffList, this.personalTariffList, true){

            public Calendar getSecondValue(PersonalTariff t) {
                return t.getDate1();
            }

            public Calendar getFirstValue(ContractTariff o) {
                return TimeUtils.convertDateToCalendar((Date)o.getPeriod().getDateFrom());
            }
        };
        while (sorter.hasNext()) {
            TariffGroup group;
            int tariffPlanID;
            TariffPlan plan;
            Element row = this.createElement(history, "row");
            Calendar date1 = null;
            Calendar date2 = null;
            String title = null;
            String type = null;
            Object next = sorter.getNext();
            if (next instanceof PersonalTariff) {
                date1 = ((PersonalTariff)next).getDate1();
                date2 = ((PersonalTariff)next).getDate2();
                title = ((PersonalTariff)next).getTitle();
                type = "1";
            } else if (next instanceof ContractTariff) {
                date1 = TimeUtils.convertDateToCalendar((Date)((ContractTariff)next).getPeriod().getDateFrom());
                date2 = TimeUtils.convertDateToCalendar((Date)((ContractTariff)next).getPeriod().getDateTo());
                type = "0";
            }
            row.setAttribute("type", type);
            row.setAttribute("tariff", title);
            row.setAttribute("date1", TimeUtils.format((Calendar)date1, (String)"dd.MM.yyyy"));
            row.setAttribute("date2", TimeUtils.format((Calendar)date2, (String)"dd.MM.yyyy"));
            GregorianCalendar now = new GregorianCalendar();
            boolean active = TimeUtils.dateBeforeOrEq((Calendar)date1, (Calendar)now) && (date2 == null || TimeUtils.dateBeforeOrEq((Calendar)now, (Calendar)date2));
            row.setAttribute("active", active ? "1" : "0");
            if (next instanceof PersonalTariff) continue;
            ContractTariff contractPlan = (ContractTariff)next;
            row.setAttribute("comment", contractPlan.getComment());
            boolean canCancel = contractPlan.getReplacedFromContractTariffId() > 0 && TimeUtils.dateBefore((Date)now.getTime(), (Date)contractPlan.getPeriod().getDateFrom());
            row.setAttribute("canCancel", canCancel ? "1" : "0");
            row.setAttribute("contractTariffId", String.valueOf(contractPlan.getId()));
            row.setAttribute("tariffId", String.valueOf(contractPlan.getTariffPlanId()));
            if (canCancel) {
                try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);){
                    ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
                    ContractTariff ct = (ContractTariff)contractTariffDao.get(contractPlan.getReplacedFromContractTariffId());
                    TariffPlan previousTariff = (TariffPlan)tariffPlanDao.get(ct.getTariffPlanId());
                    row.setAttribute("previousTariffTitle", previousTariff.getTitle());
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            if ((plan = this.tariffMap.get(tariffPlanID = contractPlan.getTariffPlanId())) == null) continue;
            row.setAttribute("tariff", plan.getTitle());
            if (contractPlan.getPeriod().getDateTo() != null || contractPlan.getPeriod().getDateFrom() != null && TimeUtils.dateBefore((Date)now.getTime(), (Date)contractPlan.getPeriod().getDateFrom()) || (group = this.findGroup(tariffPlanID)) == null) continue;
            int transferMode = group.getTransferMode();
            ArrayList<TariffPlan> changeTariffList = new ArrayList<TariffPlan>();
            List<Date> changeTariffDate = new ArrayList();
            List tariffList = group.getPlanList();
            for (TariffGroupTariff tariffGroupTariff : tariffList) {
                TariffPlan toPlan = this.tariffMap.get(tariffGroupTariff.getId());
                if (plan.getId() == toPlan.getId() || !toPlan.isUsed() || !TimeUtils.dateInRange((Date)now.getTime(), (Date)tariffGroupTariff.getDate1(), (Date)tariffGroupTariff.getDate2())) continue;
                changeTariffList.add(toPlan);
            }
            if (changeTariffList.size() == 0) continue;
            if (this.step == 1 && this.tariffGroupGetPlanIdList(group).contains(contractPlan.getTariffPlanId()) && this.tariffGroupGetPlanIdList(group).contains(this.toTariffId)) {
                this.rootNode.setAttribute("from_tariff", String.valueOf(contractPlan.getTariffPlanId()));
                GetChangeTariffDatesEvent event = new GetChangeTariffDatesEvent(this.userId.intValue(), this.cid, group, new Date(), contractPlan.getTariffPlanId(), this.toTariffId);
                event = (GetChangeTariffDatesEvent)EventProcessor.getInstance().request((QueueEvent)event);
                if (event.getDateList() != null) {
                    changeTariffDate = event.getDateList();
                } else {
                    if (transferMode != 1) {
                        if (transferMode == 4) {
                            ((Calendar)now).add(6, 1);
                        } else if (transferMode == 2) {
                            ((Calendar)now).add(3, 1);
                            now.set(7, 2);
                        } else {
                            ((Calendar)now).add(2, 1);
                            now.set(5, 1);
                        }
                    }
                    Calendar limitDate = (Calendar)((Calendar)now).clone();
                    limitDate.add(6, group.getDaysForward());
                    while (now.before(limitDate)) {
                        changeTariffDate.add(now.getTime());
                        if (transferMode == 1 || transferMode == 4) {
                            ((Calendar)now).add(6, 1);
                            continue;
                        }
                        if (transferMode == 2) {
                            ((Calendar)now).add(3, 1);
                            continue;
                        }
                        ((Calendar)now).add(2, 1);
                    }
                }
                if (changeTariffDate.size() == 0) continue;
            }
            row.setAttribute("group", String.valueOf(group.getId()));
            Element tariffListEl = this.createElement(row, "tariff_list");
            for (TariffPlan tariff : changeTariffList) {
                Element item = this.createElement(tariffListEl, "item");
                item.setAttribute("id", String.valueOf(tariff.getId()));
                item.setAttribute("title", tariff.getTitle());
            }
            Element dateListEl = this.createElement(row, "date_list");
            for (Date date : changeTariffDate) {
                Element item = this.createElement(dateListEl, "item");
                item.setAttribute("value", TimeUtils.format((Date)date, (String)"dd.MM.yyyy"));
            }
        }
    }

    protected void setDataToRequest() throws BGException {
        ArrayList list = new ArrayList();
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);){
            for (ContractTariff contractPlan : this.contractTariffList) {
                TariffGroup group;
                HashMap<String, Object> tarifPlanMap = new HashMap<String, Object>();
                list.add(tarifPlanMap);
                tarifPlanMap.put("date1", TimeUtils.format((Date)contractPlan.getPeriod().getDateFrom(), (String)"dd.MM.yyyy"));
                tarifPlanMap.put("date2", TimeUtils.format((Date)contractPlan.getPeriod().getDateTo(), (String)"dd.MM.yyyy"));
                GregorianCalendar now = new GregorianCalendar();
                boolean active = TimeUtils.dateBeforeOrEq((Date)contractPlan.getPeriod().getDateFrom(), (Date)now.getTime()) && (contractPlan.getPeriod().getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)now.getTime(), (Date)contractPlan.getPeriod().getDateTo()));
                tarifPlanMap.put("active", active ? "1" : "0");
                tarifPlanMap.put("comment", contractPlan.getComment());
                int tariffPlanID = contractPlan.getTariffPlanId();
                TariffPlan plan = this.tariffMap.get(tariffPlanID);
                if (plan == null) continue;
                tarifPlanMap.put("tariff", plan.getTitle());
                if (contractPlan.getPeriod().getDateTo() != null || contractPlan.getPeriod().getDateFrom() != null && TimeUtils.dateBefore((Date)now.getTime(), (Date)contractPlan.getPeriod().getDateFrom()) || (group = this.findGroup(tariffPlanID)) == null) continue;
                int transferMode = group.getTransferMode();
                ArrayList<TariffPlan> changeTariffList = new ArrayList<TariffPlan>();
                List<Date> changeTariffDate = new ArrayList();
                List tariffList = tariffPlanDao.list(this.tariffGroupGetPlanIdList(group));
                for (TariffPlan toPlan : tariffList) {
                    if (plan.getId() == toPlan.getId() || !toPlan.isUsed()) continue;
                    changeTariffList.add(toPlan);
                }
                if (changeTariffList.size() == 0) continue;
                GetChangeTariffDatesEvent event = new GetChangeTariffDatesEvent(this.userId.intValue(), this.cid, group, new Date(), contractPlan.getTariffPlanId(), this.toTariffId);
                event = (GetChangeTariffDatesEvent)EventProcessor.getInstance().request((QueueEvent)event);
                if (event.getDateList() != null) {
                    changeTariffDate = event.getDateList();
                } else {
                    if (transferMode != 1) {
                        if (transferMode == 4) {
                            ((Calendar)now).add(6, 1);
                        } else if (transferMode == 2) {
                            ((Calendar)now).add(3, 1);
                            now.set(7, 2);
                        } else {
                            ((Calendar)now).add(2, 1);
                            now.set(5, 1);
                        }
                    }
                    Calendar limitDate = (Calendar)((Calendar)now).clone();
                    limitDate.add(6, group.getDaysForward());
                    while (now.before(limitDate)) {
                        changeTariffDate.add(now.getTime());
                        if (transferMode == 1 || transferMode == 4) {
                            ((Calendar)now).add(6, 1);
                            continue;
                        }
                        if (transferMode == 2) {
                            ((Calendar)now).add(3, 1);
                            continue;
                        }
                        ((Calendar)now).add(2, 1);
                    }
                }
                if (changeTariffDate.size() == 0) continue;
                tarifPlanMap.put("group", String.valueOf(group.getId()));
                tarifPlanMap.put("tariff_list", changeTariffList);
                tarifPlanMap.put("date_list", changeTariffDate);
            }
        }
        this.dataMap.put("tariffList", list);
    }
}

