/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.client.UserCardPacketEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardPacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.function.Async;

public class CardPacketProcessor
extends BGUPanel {
    private UserCardPacketEditor cardPacketEditor;
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private final BGControlPanelListSelect cardListSelect;
    private BGControlPanelListSelect packets = new BGControlPanelListSelect();
    public static final int MODE_OPEN = 1;
    public static final int MODE_CLOSE = 2;
    private final int mode;

    public CardPacketProcessor(int mode) {
        this.mode = mode;
        this.packets.setBorder((Border)new BGTitleBorder("\u041f\u0430\u043a\u0435\u0442\u044b"));
        this.cardListSelect = new BGControlPanelListSelect();
        this.cardListSelect.setBorder((Border)new BGTitleBorder("\u041a\u0430\u0440\u0442\u044b"));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> {
            if (e.getActionCommand().equals("ok")) {
                this.performAction("close");
            } else {
                this.cardPacketEditor.showCardPackets();
            }
        });
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel((mode == 1 ? "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043a\u0435\u0442\u044b " : "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043a\u0435\u0442\u044b ") + "\u0441 \u0434\u0430\u0442\u044b: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.date, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridLayout());
        panel.add((Component)this.cardListSelect);
        panel.add((Component)this.packets);
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    protected void jbInit() throws Exception {
    }

    public void setCardPacketEditor(UserCardPacketEditor cardPacketEditor) {
        this.cardPacketEditor = cardPacketEditor;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> {
            ClientUtils.buildList((JList)this.cardListSelect.getList(), (List)((UserCardService)((ClientContext)this.getContext()).getPort(UserCardService.class)).getUserCardList(((ClientContext)this.getContext()).getContractId(), false));
            ClientUtils.buildList((JList)this.packets.getList(), (List)((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).packetList(Boolean.valueOf(false)));
        }));
        new AbstractBGUPanel.DefaultAction("close", "close"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                block7: {
                    Date date = CardPacketProcessor.this.date.getDate();
                    String card = CardPacketProcessor.this.cardListSelect.getListValues();
                    if (Utils.isBlankString((String)card) || date == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0438 \u043a\u0430\u0440\u0442\u0443!");
                        return;
                    }
                    try {
                        if (CardPacketProcessor.this.mode == 1) {
                            ((CardPacketService)((ClientContext)CardPacketProcessor.this.getContext()).getPort(CardPacketService.class)).openCardPackets(card, CardPacketProcessor.this.packets.getListValues(), date, ((ClientContext)CardPacketProcessor.this.getContext()).getContractId(), true);
                        } else {
                            ((CardPacketService)((ClientContext)CardPacketProcessor.this.getContext()).getPort(CardPacketService.class)).closeCardPackets(card, CardPacketProcessor.this.packets.getListValues(), date, ((ClientContext)CardPacketProcessor.this.getContext()).getContractId(), true);
                        }
                        CardPacketProcessor.this.cardPacketEditor.showCardPackets();
                    }
                    catch (BGMessageException ex) {
                        String message = ex.getMessage();
                        if (!ClientUtils.confirm((String)(message + "\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?"), (String)"\u041e\u0448\u0438\u0431\u043a\u0430")) break block7;
                        if (CardPacketProcessor.this.mode == 1) {
                            ((CardPacketService)((ClientContext)CardPacketProcessor.this.getContext()).getPort(CardPacketService.class)).openCardPackets(card, CardPacketProcessor.this.packets.getListValues(), date, ((ClientContext)CardPacketProcessor.this.getContext()).getContractId(), false);
                        } else {
                            ((CardPacketService)((ClientContext)CardPacketProcessor.this.getContext()).getPort(CardPacketService.class)).closeCardPackets(card, CardPacketProcessor.this.packets.getListValues(), date, ((ClientContext)CardPacketProcessor.this.getContext()).getContractId(), false);
                        }
                        CardPacketProcessor.this.cardPacketEditor.showCardPackets();
                    }
                }
            }
        };
    }
}

