/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.admin.web.client.WebMenuEditor;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.GuiTitlable;

public class WebMenuDefaultEditor
extends BGUPanel {
    private WebMenuEditor webMenuEditor;
    private BGUList<WebMenuComponent> componentList = null;
    private BGUList<WebMenuComponent> componentItemList = null;
    private ListSelectionListener componentListSelectionListener = null;

    public WebMenuDefaultEditor(WebMenuEditor webMenuEditor) {
        this.webMenuEditor = webMenuEditor;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridLayout(1, 2, 10, 0));
        this.add(this.getComponentPanel());
        this.add(this.getComponentItemPanel());
    }

    private JPanel getComponentPanel() {
        this.componentList = new BGUList();
        this.componentList.setCellRenderer((ListCellRenderer)new ComponentListCellRenderer());
        this.componentList.setSelectionMode(0);
        this.componentListSelectionListener = e -> {
            WebMenuComponent webMenuComponent = (WebMenuComponent)this.componentList.getSelectedValue();
            ArrayList data = new ArrayList();
            if (webMenuComponent != null) {
                webMenuComponent.json.optJSONArray("items").forEach(a -> data.add(new WebMenuComponent((JSONObject)a)));
            }
            this.componentItemList.setData(data);
        };
        this.componentList.addListSelectionListener(this.componentListSelectionListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.componentList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getComponentItemPanel() {
        this.componentItemList = new BGUList();
        this.componentItemList.setCellRenderer((ListCellRenderer)new ComponentItemListCellRenderer());
        this.componentItemList.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.componentItemList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ArrayList data = new ArrayList();
            this.webMenuEditor.getWebService().getComponentList().forEach(a -> data.add(new WebMenuComponent((JSONObject)a)));
            this.componentList.removeListSelectionListener(this.componentListSelectionListener);
            this.componentList.setData(data);
            this.componentList.addListSelectionListener(this.componentListSelectionListener);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.componentList.optSelectedValue().ifPresentOrElse(a -> new ComponentEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", (WebMenuComponent)a).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043b\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
    }

    class ComponentListCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel(new GridBagLayout());
        private JLabel titleLabel = new JLabel();
        private JLabel nameIdLabel = new JLabel();
        private JLabel descriptionLabel = new JLabel();

        public ComponentListCellRenderer() {
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1).deriveFont(this.titleLabel.getFont().getSize2D() * 1.4f));
            Color fgColor = UIManager.getColor("TextField.inactiveForeground");
            this.nameIdLabel.setForeground(fgColor);
            this.descriptionLabel.setForeground(fgColor);
            this.panel.add((Component)this.getLine1Panel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.descriptionLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getLine1Panel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            panel.add((Component)this.titleLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.nameIdLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            return panel;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            WebMenuComponent webMenuComponent = (WebMenuComponent)value;
            this.titleLabel.setText(webMenuComponent.json.optString("moduleTitle") + " (" + webMenuComponent.json.optJSONArray("items").length() + ")");
            this.nameIdLabel.setText(webMenuComponent.json.optString("moduleName") + "#" + webMenuComponent.json.optString("moduleId"));
            this.descriptionLabel.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: " + webMenuComponent.json.optString("description"));
            this.panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this.panel;
        }
    }

    class ComponentItemListCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel(new GridBagLayout());
        private JLabel titleLabel = new JLabel();
        private JLabel nameIdLabel = new JLabel();
        private JLabel descriptionLabel = new JLabel();

        public ComponentItemListCellRenderer() {
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1).deriveFont(this.titleLabel.getFont().getSize2D() * 1.4f));
            Color fgColor = UIManager.getColor("TextField.inactiveForeground");
            this.nameIdLabel.setForeground(fgColor);
            this.descriptionLabel.setForeground(fgColor);
            this.panel.add((Component)this.getLine1Panel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.descriptionLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getLine1Panel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            panel.add((Component)this.titleLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.nameIdLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            return panel;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            WebMenuComponent webMenuComponent = (WebMenuComponent)value;
            this.titleLabel.setText(webMenuComponent.json.optString("title") + " icon:" + webMenuComponent.json.optString("icon"));
            this.nameIdLabel.setText("action: " + webMenuComponent.json.optString("action") + "  #" + webMenuComponent.json.optString("id"));
            this.descriptionLabel.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: " + webMenuComponent.json.optString("description"));
            this.panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this.panel;
        }
    }

    class ComponentEditor
    extends BGEditorDialog<WebMenuComponent> {
        public ComponentEditor(String title, WebMenuComponent data) {
            super(title, (Object)data);
        }
    }

    class WebMenuComponent
    implements GuiTitlable {
        JSONObject json;

        public WebMenuComponent(JSONObject json) {
            this.json = json;
        }

        public String getGuiTitle() {
            return this.json.optString("title") + " #" + this.json.optString("id");
        }

        public String toString() {
            return this.json.toString();
        }
    }
}

