/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceConfigZone
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel editPanel = new JPanel(new GridBagLayout());
    private BGTextField name = new BGTextField();
    private JCheckBox domain = new JCheckBox("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043c\u0435\u043d\u043e\u0432");
    private JCheckBox host = new JCheckBox("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0445\u043e\u0441\u0442\u043e\u0432");
    private BGComboBox<ComboBoxItem> nsServerCB = new BGComboBox();
    private JTextArea comment = new JTextArea();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    public ServiceConfigZone() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "zone");
    }

    private void jbInit() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" Domain/Host "));
        panel.add((Component)this.domain, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.host, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel = panel;
        panel = new JPanel(new GridBagLayout());
        jPanel.add((Component)panel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("NS \u0441\u0435\u0440\u0432\u0435\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.nsServerCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        JPanel panel1 = new JPanel(new GridBagLayout());
        panel1.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        panel1.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.editPanel.add((Component)new JLabel("\u0417\u043e\u043d\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)this.name, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)panel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.editPanel.add((Component)panel1, new GridBagConstraints(2, 0, 1, 3, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.okCancel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigZone.this.editItem();
                }
            }
        });
        this.okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigZone.this.setData();
            }
        });
        this.host.addChangeListener(e -> this.nsServerCB.setEnabled(this.host.isSelected()));
    }

    public void setData() {
    }

    public void startEdit() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("NsServerList");
        req.setAttribute("type", "master");
        try {
            Document doc = this.getDocument(req);
            ClientUtils.buildComboBox(this.nsServerCB, (Node)XMLUtils.selectNode((Node)doc, (String)"//list"), null);
            if (this.id != null) {
                req = new Request();
                req.setModule(this.module);
                req.setModuleId(this.getModuleId());
                req.setAction("ZoneGet");
                req.setAttribute("id", this.id);
                doc = this.getDocument(req);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element zone = XMLUtils.selectElement((Node)doc, (String)"//zone");
                    this.name.setText(zone.getAttribute("name"));
                    this.comment.setText(zone.getAttribute("comment"));
                    ClientUtils.setComboBoxSelection(this.nsServerCB, (Object)zone.getAttribute("masterNsId"));
                    this.domain.setSelected("1".equals(zone.getAttribute("domain")));
                    this.host.setSelected("1".equals(zone.getAttribute("host")));
                }
            } else {
                this.name.setText("");
                this.comment.setText("");
                this.domain.setSelected(false);
                this.host.setSelected(false);
            }
            this.nsServerCB.setEnabled(this.host.isSelected());
            this.editPanel.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopEdit(boolean save) {
        if (save) {
            Document doc;
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("ZoneUpdate");
            req.setAttribute("id", this.id);
            req.setAttribute("name", this.name.getText());
            req.setAttribute("comment", this.comment.getText());
            req.setAttribute("domain", this.domain.isSelected() ? "1" : "0");
            req.setAttribute("host", this.host.isSelected() ? "1" : "0");
            ComboBoxItem item = (ComboBoxItem)this.nsServerCB.getSelectedItem();
            if (item != null) {
                req.setAttribute("masterNsId", item.getObject());
            }
            if (ClientUtils.checkStatus((Document)(doc = this.getDocument(req)))) {
                this.editPanel.setVisible(false);
            }
        } else {
            this.editPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043e\u043d\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("ZoneDelete");
            request.setAttribute("id", this.id);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != null) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.id = null;
        this.startEdit();
    }
}

