/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import ru.bitel.bgbilling.client.common.BGDraggableTabbedPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.GroupParent;

public class ServiceConfig
extends BGTabPanel {
    private Set<Component> settedComponents = new HashSet<Component>();
    private BGDraggableTabbedPane tabPane = new BGDraggableTabbedPane();

    public ServiceConfig(int moduleId, String rb_name) {
        this(moduleId, rb_name, "module_config_" + moduleId);
    }

    public ServiceConfig(int moduleId, String rb_name, String tabId) {
        super(tabId, "Config");
        this.setModuleId(moduleId);
        this.rb_name = rb_name;
        this.module = ClientUtils.getValueFromResourceBundle(rb_name, "module.id");
        this.tabTitle = ClientUtils.getValueFromResourceBundle(rb_name, "module.title");
        this.tabPane.setKey("BGDraggableTabbedPane:" + this.module + ":" + moduleId + ":" + ServiceConfig.class.getName());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.tabPane.addChangeListener(e -> this.jTabbedPane_stateChanged(e));
    }

    private void setTabs() {
        String moduleTab = ClientUtils.getValueFromResourceBundle(this.rb_name, "module.tab");
        if (moduleTab != null) {
            ArrayList<String> tabsList = new ArrayList<String>();
            for (String tabIndex : moduleTab.split(" ")) {
                tabsList.add(tabIndex);
            }
            String userTabOrder = ClientSetup.getInstance().getUserConfig().get(this.tabPane.getKey());
            if (userTabOrder != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (String tabIndex : userTabOrder.split(" ")) {
                    if (!tabsList.contains(tabIndex)) continue;
                    list.add(tabIndex);
                    tabsList.remove(tabIndex);
                }
                list.addAll(tabsList);
                tabsList = list;
            }
            boolean refresh = true;
            for (String tabIndex : tabsList) {
                this.addTab(refresh, tabIndex);
                refresh = false;
            }
        } else {
            int i = 1;
            while (this.addTab(i == 1, String.valueOf(i))) {
                ++i;
            }
        }
    }

    private boolean addTab(boolean refresh, String tabIndex) {
        boolean flag;
        block10: {
            flag = true;
            String prefix = "module.tab." + tabIndex + ".";
            try {
                String title = ClientUtils.getValueFromResourceBundle(this.rb_name, prefix.concat("title"));
                String className = ClientUtils.getValueFromResourceBundle(this.rb_name, prefix.concat("class"));
                if (title != null && className != null) {
                    ServiceConfigPane serviceConfigPane = new ServiceConfigPane(refresh, className, this.getModuleId(), this.rb_name, tabIndex);
                    this.tabPane.add((Component)serviceConfigPane, title);
                    try {
                        JPanel panel = (JPanel)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                        serviceConfigPane.setPanel(panel);
                        if (panel instanceof ServiceConfigTabbedPanel) {
                            ServiceConfigTabbedPanel p = (ServiceConfigTabbedPanel)panel;
                            p.init(this.module, this.getModuleId());
                            p.setClientPackage(this.rb_name);
                            if (refresh) {
                                SwingUtilities.invokeLater(() -> p.trySetData());
                            }
                        } else if (panel instanceof BGUPanel) {
                            BGUPanel p = (BGUPanel)panel;
                            if (refresh) {
                                p.build();
                                SwingUtilities.invokeLater(() -> p.performAction("refresh"));
                            }
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                    break block10;
                }
                flag = false;
            }
            catch (Exception ex) {
                flag = false;
            }
        }
        return flag;
    }

    protected void jbInit() throws Exception {
        this.setTabs();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Component component = this.tabPane.getSelectedComponent();
        if (component instanceof ServiceConfigPane) {
            Action a;
            JPanel panel = ((ServiceConfigPane)component).get();
            if (panel instanceof ServiceConfigTabbedPanel) {
                ((ServiceConfigTabbedPanel)panel).trySetData();
            } else if (panel != null && (a = panel.getActionMap().get("refresh")) != null) {
                a.actionPerformed(new ActionEvent(this, 0, "refresh"));
            }
        } else if (component instanceof BGTabPanel) {
            ((BGPanel)component).trySetData();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e, this.tabPane);
    }

    public void actionPerformed(ActionEvent e, JTabbedPane jTabbedPane) {
        Component component = jTabbedPane.getSelectedComponent();
        if (component instanceof ServiceConfigPane) {
            if (((ServiceConfigPane)component).panel instanceof BGUPanel) {
                String command = e.getActionCommand();
                if ("newItem".equals(command)) {
                    command = "new";
                } else if ("editItem".equals(command)) {
                    command = "edit";
                } else if ("deleteItem".equals(command)) {
                    command = "delete";
                }
                ((BGUPanel)((ServiceConfigPane)component).panel).performAction(command);
            } else {
                ((ServiceConfigTabbedPanel)((ServiceConfigPane)component).panel).actionPerformed(e);
            }
        } else if (component instanceof ServiceConfigTabbedPanel) {
            ((ServiceConfigTabbedPanel)component).actionPerformed(e);
        } else if (component instanceof BGUPanel) {
            ((BGUPanel)component).performAction(e.getActionCommand());
        }
    }

    private void jTabbedPane_stateChanged(ChangeEvent e) {
        Component component;
        if (this.isVisible() && !this.settedComponents.contains(component = this.tabPane.getSelectedComponent())) {
            this.setData();
            this.settedComponents.add(component);
            if (component instanceof Container) {
                Container container = (Container)component;
                for (Component inComponent : container.getComponents()) {
                    if (!(inComponent instanceof BGUTabPanel)) continue;
                    BGUTabPanel tabPanel = (BGUTabPanel)inComponent;
                    tabPanel.performAction("init");
                }
            }
        }
    }

    public ServiceConfigTabbedPanel getTab(String className) {
        ServiceConfigTabbedPanel result = null;
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component comp = this.tabPane.getComponentAt(i);
            if (comp instanceof ServiceConfigPane) {
                comp = ((ServiceConfigPane)comp).get();
            }
            if (!comp.getClass().getName().equals(className)) continue;
            result = (ServiceConfigTabbedPanel)comp;
            break;
        }
        return result;
    }

    public BGUPanel getTabNew(String className) {
        BGUPanel result = null;
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component comp = this.tabPane.getComponentAt(i);
            if (comp instanceof ServiceConfigPane) {
                comp = ((ServiceConfigPane)comp).get();
            }
            if (!comp.getClass().getName().equals(className)) continue;
            result = (BGUPanel)comp;
            break;
        }
        return result;
    }

    public void selectTab(String className) {
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component comp = this.tabPane.getComponentAt(i);
            if (comp instanceof ServiceConfigPane) {
                comp = ((ServiceConfigPane)comp).get();
            }
            if (!comp.getClass().getName().equals(className)) continue;
            this.tabPane.setSelectedIndex(i);
            break;
        }
    }

    public class ServiceConfigPane
    extends BGUPanel
    implements GroupParent {
        private JPanel panel;
        private String tabIndex;

        private ServiceConfigPane(boolean refresh, String className, int moduleId, String rb_name, String tabIndex) {
            super((LayoutManager)new GridLayout(), ClientContext.get());
            this.tabIndex = tabIndex;
            this.build();
        }

        private void setPanel(JPanel panel) {
            this.panel = panel;
            this.add(panel);
            this.updateUI();
        }

        public JPanel get() {
            return this.panel;
        }

        @Override
        protected void jbInit() {
        }

        public String getTabIndex() {
            return this.tabIndex;
        }
    }
}

