/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.admin.bgsecure.ConfigPanel;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGPasswordField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.client.MenuRestrictPanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.common.event.RoleUpdateEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class UserEditor
extends BGUPanel
implements EventSubscriber<RoleUpdateEvent> {
    private JTextField userName = new JTextField();
    private JTextField userLogin = new JTextField();
    private JTextField userEmail = new JTextField();
    private JTextField userDescr = new JTextField();
    private BGUComboBox<IdTitle> statusCombo = new BGUComboBox();
    private BGPasswordField userPassword1 = new BGPasswordField();
    private JPasswordField userPassword2 = new JPasswordField();
    private JCheckBox needChangePassword = new JCheckBox("\u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435");
    private JCheckBox disableSavePassword = new JCheckBox("\u0437\u0430\u043f\u0440\u0435\u0442\u0438\u0442\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c");
    private BGUComboBox<IdTitle> pidCombo = new BGUComboBox();
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect(false, true, true);
    private BGUComboBox<RoleItem> roleComboBox = new BGUComboBox();
    private ConfigPanel configPanel = new ConfigPanel();
    private MenuRestrictPanel menuRestrictPanel = new MenuRestrictPanel(false);
    private User user;
    private String lastActionCommand;
    private JTabbedPane tabbedPanel = new JTabbedPane();
    AbstractBGUPanel.DefaultAction okAction = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            if (UserEditor.this.userLogin.getText().trim().length() < 2) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u043b\u0435 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\" \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 2 \u0434\u043e 20 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
                return;
            }
            char[] pswd1 = UserEditor.this.userPassword1.getPassword();
            char[] pswd2 = UserEditor.this.userPassword1.getPassword();
            if (pswd1 == null || pswd1.length < 5) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 5 \u0434\u043e 20 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
                return;
            }
            boolean passwordsNotMatching = false;
            if (pswd2 == null || pswd1.length != pswd2.length) {
                passwordsNotMatching = true;
            } else {
                for (int i = 0; i < pswd1.length; ++i) {
                    if (pswd1[i] == pswd2[i]) continue;
                    passwordsNotMatching = true;
                    break;
                }
            }
            if (passwordsNotMatching) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
                return;
            }
            if (UserEditor.this.user == null) {
                UserEditor.this.user = new User();
            }
            UserEditor.this.user.setLogin(UserEditor.this.userLogin.getText().trim());
            UserEditor.this.user.setName(UserEditor.this.userName.getText().trim());
            UserEditor.this.user.setEmail(UserEditor.this.userEmail.getText().trim());
            UserEditor.this.user.setDescription(UserEditor.this.userDescr.getText().trim());
            UserEditor.this.user.setStatus(((IdTitle)UserEditor.this.statusCombo.getSelectedItem()).getId());
            UserEditor.this.user.setContractPid(((IdTitle)UserEditor.this.pidCombo.getSelectedItem()).getId());
            UserEditor.this.user.setContractCid(Utils.parseInt((String)UserEditor.this.contractSelect.getContracts(), (int)0));
            RoleItem role = (RoleItem)UserEditor.this.roleComboBox.getSelectedItem();
            UserEditor.this.user.setRoleId(role != null ? role.getId() : 0);
            if (!"passwordpassword".equals(new String(pswd1))) {
                UserEditor.this.user.setPasswordPlainText(new String(pswd1));
            }
            UserEditor.this.user.setNeedChangePassword(UserEditor.this.needChangePassword.isSelected());
            UserEditor.this.user.setDisableSavePassword(UserEditor.this.disableSavePassword.isSelected());
            UserEditor.this.user.setConfig(UserEditor.this.configPanel.getConfigText());
            UserEditor.this.menuRestrictPanel.updateData();
            ((UserService)((ClientContext)UserEditor.this.getContext()).getPort(UserService.class)).updateUser(UserEditor.this.user, Collections.emptyList());
            UserEditor.this.setVisible(false);
        }
    };

    public UserEditor() {
    }

    public UserEditor(ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
        this.build();
    }

    protected void jbInit() throws Exception {
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        okCancelPanel.addActionListener(e -> this.okCancelPerformed(e));
        this.add(this.getUserInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getTabbedPanel(), new GridBagConstraints(1, 0, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getPasswordPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getContractPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getRolePanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)okCancelPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        EventBus.subscribe(RoleUpdateEvent.class, (EventSubscriber)this);
    }

    public void onEvent(RoleUpdateEvent event) {
        if (this.user != null && this.user.getRoleId() > 0) {
            ClientUtils.setComboBoxSelection(this.roleComboBox, (int)this.user.getRoleId());
        }
    }

    private JPanel getContractPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.pidCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.contractSelect, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 "));
        return panel;
    }

    private JPanel getRolePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ClientUtils.getIcon((String)"user")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.roleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.setBorder((Border)new BGTitleBorder(" \u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u0430\u044f \u0440\u043e\u043b\u044c "));
        return panel;
    }

    private JPanel getPasswordPanel() {
        this.userPassword1.setMinimumSize(new Dimension(4, 24));
        this.userPassword1.setPreferredSize(new Dimension(4, 24));
        this.userPassword2.setMinimumSize(new Dimension(4, 24));
        this.userPassword2.setOpaque(true);
        this.userPassword2.setPreferredSize(new Dimension(4, 24));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u043e\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f "));
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userPassword1, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.userPassword2, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.needChangePassword, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 0, 0, 5), 0, 0));
        panel.add((Component)this.disableSavePassword, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 0, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getUserInfoPanel() {
        this.statusCombo.addItem((Object)new IdTitle(0, "\u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442"));
        this.statusCombo.addItem((Object)new IdTitle(1, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.userDescr.setMinimumSize(new Dimension(330, 24));
        this.userDescr.setPreferredSize(new Dimension(330, 24));
        this.userDescr.setColumns(30);
        this.userName.setMinimumSize(new Dimension(330, 24));
        this.userName.setPreferredSize(new Dimension(330, 24));
        this.userName.setColumns(30);
        this.userLogin.setMinimumSize(new Dimension(330, 24));
        this.userLogin.setPreferredSize(new Dimension(330, 24));
        this.userLogin.setColumns(30);
        this.userEmail.setMinimumSize(new Dimension(330, 24));
        this.userEmail.setPreferredSize(new Dimension(330, 24));
        this.userEmail.setColumns(30);
        int row = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 "));
        panel.add((Component)new JLabel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userLogin, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userName, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("E-mail:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userEmail, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userDescr, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.statusCombo, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JTabbedPane getTabbedPanel() {
        this.configPanel.setToolTipText("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        JPanel contractGroupPanel = new JPanel(new GridBagLayout());
        contractGroupPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        contractGroupPanel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
        this.tabbedPanel.add((Component)((Object)this.menuRestrictPanel), "\u041f\u0443\u043d\u043a\u0442\u044b \u043c\u0435\u043d\u044e");
        this.tabbedPanel.add((Component)this.configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        return this.tabbedPanel;
    }

    public void setRoleItems(List<RoleItem> roleItems) {
        ArrayList<RoleItem> roles = new ArrayList<RoleItem>();
        roles.add(new RoleItem(-1, "-------------------------"));
        roles.addAll(roleItems);
        this.roleComboBox.setData(roles);
        this.roleComboBox.setSelectedIndex(0);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(IdTitle.NO_SELECT);
            List<ContractParameterGroupAttr> parameterGroupAttrList = ((ContractParameterService)((ClientContext)this.getContext()).getPort(ContractParameterService.class)).contractParameterGroupAttrList();
            parameterGroupAttrList.removeIf(param -> param.getType() != 31);
            parameters.addAll(parameterGroupAttrList);
            this.pidCombo.setData(parameters);
            this.pidCombo.setSelectedIndex(0);
        });
    }

    private void okCancelPerformed(ActionEvent e) {
        this.lastActionCommand = e.getActionCommand();
        if ("reset".equals(this.lastActionCommand)) {
            this.performAction("refresh");
        } else if ("ok".equals(this.lastActionCommand)) {
            this.performAction("ok");
        } else if ("cancel".equals(this.lastActionCommand)) {
            this.setUser(null);
            this.setVisible(false);
        }
    }

    public void setUser(User user) {
        this.user = user;
        if (user != null) {
            this.userLogin.setText(user.getLogin());
            this.userName.setText(user.getName());
            this.userEmail.setText(user.getEmail());
            this.userDescr.setText(user.getDescription());
            this.userPassword1.setText("passwordpassword");
            this.userPassword2.setText("passwordpassword");
            this.needChangePassword.setSelected(user.isNeedChangePassword());
            this.disableSavePassword.setSelected(user.isDisableSavePassword());
            ClientUtils.setComboBoxSelection(this.statusCombo, (int)user.getStatus());
            ClientUtils.setComboBoxSelection(this.pidCombo, (int)user.getContractPid());
            this.contractSelect.setContracts(String.valueOf(user.getContractCid()), user.getContractTitle());
            ClientUtils.setComboBoxSelection(this.roleComboBox, (int)user.getRoleId());
            this.configPanel.setConfigText(user.getConfig());
            this.menuRestrictPanel.setUserOrGroupId(user.getId());
            this.menuRestrictPanel.setData();
            this.tabbedPanel.setSelectedIndex(0);
        }
        this.setVisible(true);
    }

    public String getLastActionCommand() {
        return this.lastActionCommand;
    }
}

